/*
 * Decompiled with CFR 0.152.
 */
package cn.someget.cache.service.impl;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.text.CharSequenceUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.someget.cache.service.CacheService;
import cn.someget.cache.utils.RedisRepository;
import com.alibaba.fastjson.JSON;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service(value="defaultRedisCacheService")
public class RedisCacheServiceImpl
implements CacheService {
    @Resource
    private RedisRepository redisRepository;

    @Override
    public <V> V getObjectFromCache(String key, Class<V> clazz) {
        if (CharSequenceUtil.isBlank((CharSequence)key)) {
            return null;
        }
        String result = this.redisRepository.get(key);
        return (V)(result == null ? null : JSON.parseObject((String)result, clazz));
    }

    @Override
    public <V> List<V> getObjectListFromCache(String key, Class<V> clazz) {
        if (CharSequenceUtil.isBlank((CharSequence)key)) {
            return new ArrayList();
        }
        String result = this.redisRepository.get(key);
        return result == null ? Collections.emptyList() : JSON.parseArray((String)result, clazz);
    }

    @Override
    public <K, V> Map<K, V> getObjectFromCache(List<K> ids, Class<V> clazz, String prefix) {
        if (CollUtil.isEmpty(ids)) {
            return Collections.emptyMap();
        }
        Map<K, String> cacheData = this.getRedisData(ids, prefix);
        return cacheData.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> JSON.parseObject((String)((String)entry.getValue()), (Class)clazz)));
    }

    @Override
    public <K, V> Map<K, List<V>> getObjectListFromCache(List<K> ids, Class<V> clazz, String prefix) {
        if (CollUtil.isEmpty(ids)) {
            return Collections.emptyMap();
        }
        Map<K, String> cacheData = this.getRedisData(ids, prefix);
        return cacheData.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> JSON.parseArray((String)((String)entry.getValue()), (Class)clazz)));
    }

    private <K> Map<K, String> getRedisData(List<K> ids, String prefix) {
        ids = ids.stream().filter(ObjectUtil::isNotNull).collect(Collectors.toList());
        List<String> keys = ids.stream().map(id -> String.format(prefix, id)).collect(Collectors.toList());
        Map<String, String> cacheData = this.redisRepository.multiGet(keys);
        HashMap<Object, String> result = new HashMap<Object, String>(cacheData.size());
        for (Object id2 : ids) {
            String key = String.format(prefix, id2);
            String value = cacheData.get(key);
            if (StringUtils.isEmpty((Object)value)) continue;
            result.put(id2, value);
        }
        return result;
    }
}

