/*
 * Decompiled with CFR 0.152.
 */
package cn.someget.cache.utils;

import cn.hutool.core.map.MapUtil;
import cn.someget.cache.utils.LocalCache;
import com.alibaba.fastjson.JSON;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.redis.core.ReactiveRedisOperations;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.data.redis.serializer.RedisSerializer;
import org.springframework.data.redis.serializer.StringRedisSerializer;
import org.springframework.stereotype.Repository;

@Repository
public class RedisRepository {
    private static final Logger log = LoggerFactory.getLogger(RedisRepository.class);
    @Resource
    private LocalCache localCache;
    protected RedisTemplate<String, String> redisTemplate;

    @Resource(name="redisTemplate")
    public void setRedisTemplate(RedisTemplate<String, String> redisTemplate) {
        StringRedisSerializer stringSerializer = new StringRedisSerializer();
        redisTemplate.setKeySerializer((RedisSerializer)stringSerializer);
        redisTemplate.setValueSerializer((RedisSerializer)stringSerializer);
        redisTemplate.setHashKeySerializer((RedisSerializer)stringSerializer);
        redisTemplate.setHashValueSerializer((RedisSerializer)stringSerializer);
        this.redisTemplate = redisTemplate;
    }

    public Map<String, String> multiGet(List<String> keys) {
        return null;
    }

    public void multiExpire(Map<String, Long> expireMap, TimeUnit seconds) {
    }

    public ReactiveRedisOperations<Object, Object> getRedisTemplate() {
        return null;
    }

    public String get(String key) {
        return null;
    }

    public void batchWriteRedis(Map<String, Object> keyValues, Long expire) {
        if (MapUtil.isEmpty(keyValues)) {
            return;
        }
        try {
            HashMap<String, Long> expireMap = new HashMap<String, Long>(keyValues.size());
            HashMap valueMap = new HashMap(keyValues.size());
            keyValues.forEach((k, v) -> {
                expireMap.put((String)k, expire);
                if (v instanceof String) {
                    valueMap.put(k, (String)v);
                } else {
                    valueMap.put(k, JSON.toJSONString((Object)v));
                }
            });
            this.getRedisTemplate().opsForValue().multiSet(valueMap);
            log.info("redis multiSet, valueMap:{}", (Object)JSON.toJSONString(valueMap));
            this.multiExpire(expireMap, TimeUnit.SECONDS);
        }
        catch (Exception e) {
            log.warn("redis setIfAbsent error, keyValues:{}, expire:{}", new Object[]{JSON.toJSONString(keyValues), expire, e});
            HashMap<String, Object> caches = new HashMap<String, Object>(keyValues.size());
            keyValues.forEach(caches::put);
            this.localCache.putAll(caches);
        }
    }

    public void writeRedis(String key, Long expire, Object value) {
        HashMap<String, Object> keyValues = new HashMap<String, Object>(1);
        keyValues.put(key, value);
        this.batchWriteRedis(keyValues, expire);
    }
}

