/*
 * Decompiled with CFR 0.152.
 */
package cn.someget.cache.service.impl;

import cn.hutool.core.map.MapUtil;
import cn.hutool.core.util.StrUtil;
import cn.someget.cache.service.CacheService;
import cn.someget.cache.utils.LocalCache;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service(value="defaultLocalCacheService")
public class LocalCacheServiceImpl
implements CacheService {
    @Resource(name="defaultRedisCacheService")
    private CacheService defaultRedisCacheService;
    @Resource
    private LocalCache localCache;

    @Override
    public <V> V getObjectFromCache(String key, Class<V> clazz) {
        if (StrUtil.isBlank((CharSequence)key)) {
            return null;
        }
        Object value = this.localCache.getIfPresent(key);
        if (value != null) {
            return (V)value;
        }
        V v = this.defaultRedisCacheService.getObjectFromCache(key, clazz);
        if (v == null) {
            return null;
        }
        this.localCache.put(key, v);
        return v;
    }

    @Override
    public <V> List<V> getObjectListFromCache(String key, Class<V> clazz) {
        if (StrUtil.isBlank((CharSequence)key)) {
            return new ArrayList();
        }
        List value = (List)this.localCache.getIfPresent(key);
        if (value != null) {
            return value;
        }
        List<V> v = this.defaultRedisCacheService.getObjectListFromCache(key, clazz);
        if (CollectionUtils.isEmpty(v)) {
            return new ArrayList();
        }
        this.localCache.put(key, v);
        return v;
    }

    @Override
    public <K, V> Map<K, V> getObjectFromCache(List<K> ids, Class<V> clazz, String prefix) {
        if (CollectionUtils.isEmpty(ids)) {
            return new HashMap(0);
        }
        ids.removeIf(Objects::isNull);
        List<String> keys = ids.stream().map(p -> String.format(prefix, p)).collect(Collectors.toList());
        Map<String, Object> allPresent = this.localCache.getAllPresent(keys);
        HashMap<Object, Object> results = new HashMap<Object, Object>(ids.size());
        ArrayList<K> missIds = new ArrayList<K>();
        for (K id : ids) {
            String key = String.format(prefix, id);
            Object v = allPresent.get(key);
            if (v != null) {
                results.put(id, v);
                continue;
            }
            missIds.add(id);
        }
        if (CollectionUtils.isEmpty(missIds)) {
            return results;
        }
        Map objectFromCache = this.defaultRedisCacheService.getObjectFromCache(missIds, clazz, prefix);
        HashMap<String, Object> needCacheObjects = new HashMap<String, Object>(missIds.size());
        for (Object k : missIds) {
            V v = objectFromCache.get(k);
            if (v == null) continue;
            needCacheObjects.put(String.format(prefix, k), v);
            results.put(k, v);
        }
        if (MapUtil.isNotEmpty(needCacheObjects)) {
            this.localCache.putAll(needCacheObjects);
        }
        return results;
    }

    @Override
    public <K, V> Map<K, List<V>> getObjectListFromCache(List<K> ids, Class<V> clazz, String prefix) {
        if (CollectionUtils.isEmpty(ids)) {
            return new HashMap(0);
        }
        ids.removeIf(Objects::isNull);
        List<String> keys = ids.stream().map(p -> String.format(prefix, p)).collect(Collectors.toList());
        Map<String, Object> allPresent = this.localCache.getAllPresent(keys);
        HashMap<Object, List<V>> results = new HashMap<Object, List<V>>(ids.size());
        ArrayList<K> missIds = new ArrayList<K>();
        for (K id : ids) {
            String key = String.format(prefix, id);
            List v = (List)allPresent.get(key);
            if (v != null) {
                results.put(id, v);
                continue;
            }
            missIds.add(id);
        }
        if (CollectionUtils.isEmpty(missIds)) {
            return results;
        }
        Map objectListFromCache = this.defaultRedisCacheService.getObjectListFromCache(missIds, clazz, prefix);
        HashMap<String, Object> needCacheObjects = new HashMap<String, Object>(missIds.size());
        for (Object k : missIds) {
            List<V> v = objectListFromCache.get(k);
            if (v == null) continue;
            needCacheObjects.put(String.format(prefix, k), v);
            results.put(k, v);
        }
        if (MapUtil.isNotEmpty(needCacheObjects)) {
            this.localCache.putAll(needCacheObjects);
        }
        return results;
    }
}

