/*
 * Decompiled with CFR 0.152.
 */
package cn.someget.cache.aop;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.convert.Convert;
import cn.hutool.core.lang.Assert;
import cn.hutool.core.map.MapUtil;
import cn.hutool.core.text.CharSequenceUtil;
import cn.someget.cache.anno.Cache;
import cn.someget.cache.service.CacheService;
import cn.someget.cache.utils.RedisKey;
import cn.someget.cache.utils.RedisRepository;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.parser.Feature;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.UnaryOperator;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import javax.annotation.Resource;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.aspectj.lang.reflect.MethodSignature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component
@Aspect
public class CacheAspect {
    private static final Logger log = LoggerFactory.getLogger(CacheAspect.class);
    @Resource
    private RedisRepository redisRepository;
    @Resource(name="defaultRedisCacheService")
    private CacheService redisCacheService;
    @Resource(name="defaultLocalCacheService")
    private CacheService localCacheService;

    @Pointcut(value="@annotation(cn.someget.cache.anno.Cache)")
    public void cache() {
    }

    @Around(value="cache()")
    public Object doAround(ProceedingJoinPoint joinPoint) throws Throwable {
        MethodSignature methodSignature = (MethodSignature)joinPoint.getSignature();
        Method method = methodSignature.getMethod();
        Cache cache = method.getAnnotation(Cache.class);
        boolean usingLocalCache = cache.usingLocalCache();
        CacheService cacheService = usingLocalCache ? this.localCacheService : this.redisCacheService;
        String prefix = cache.prefix();
        Class<?> clazz = cache.clazz();
        boolean hasMoreValue = cache.hasMoreValue();
        long expire = cache.expire();
        long missExpire = cache.missExpire();
        Object[] args = joinPoint.getArgs();
        Class<?> returnType = method.getReturnType();
        Assert.notNull((Object)args, (String)"do not support non args", (Object[])new Object[0]);
        Object arg = args[0];
        if (arg == null) {
            log.warn("query key is null, class:{}, method:{}, args:{}", new Object[]{clazz.getName(), method.getName(), JSON.toJSONString((Object)args)});
            return null;
        }
        if (arg instanceof List) {
            Map objectFromLocalCache;
            String param2;
            Assert.isTrue((args.length <= 2 ? 1 : 0) != 0, (String)"do not support args > 2", (Object[])new Object[0]);
            boolean paramCheck = args.length == 2 && (args[1] instanceof List || arg instanceof Map);
            Assert.isFalse((boolean)paramCheck, (String)"do not support the args", (Object[])new Object[0]);
            Assert.isTrue((returnType != Map.class ? 1 : 0) != 0, (String)"param error", (Object[])new Object[0]);
            List inputList = JSON.parseArray((String)JSON.toJSONString((Object)arg), (Feature[])new Feature[0]).toJavaList(Object.class);
            if (args.length == 2 && CharSequenceUtil.isNotBlank((CharSequence)(param2 = Convert.toStr((Object)args[1], (String)"")))) {
                prefix = prefix + ":" + param2;
            }
            if (hasMoreValue) {
                objectFromLocalCache = cacheService.getObjectListFromCache(inputList, clazz, prefix);
                this.doHandleListCache(inputList, clazz, objectFromLocalCache, joinPoint, prefix, expire, instance -> new ArrayList(), args, missExpire);
                return objectFromLocalCache;
            }
            objectFromLocalCache = cacheService.getObjectFromCache(inputList, clazz, prefix);
            this.doHandleListCache(inputList, clazz, objectFromLocalCache, joinPoint, prefix, expire, instance -> this.buildEmptyObject(clazz), args, missExpire);
            return objectFromLocalCache;
        }
        String key = String.format(prefix, args);
        if (returnType == List.class) {
            return this.doHandleOne2ListCache(joinPoint, key, clazz, expire, cacheService, missExpire);
        }
        return this.doHandleOne2OneCache(joinPoint, key, expire, returnType, cacheService, missExpire);
    }

    private Object doHandleOne2ListCache(ProceedingJoinPoint joinPoint, String key, Class<?> returnType, long expire, CacheService cacheService, long missExpire) throws Throwable {
        List<?> objectListFromCache = cacheService.getObjectListFromCache(key, returnType);
        if (CollUtil.isNotEmpty(objectListFromCache)) {
            return objectListFromCache;
        }
        ArrayList proceed = joinPoint.proceed();
        if (proceed instanceof List) {
            List real = proceed;
            if (CollectionUtils.isEmpty((Collection)real)) {
                proceed = new ArrayList();
                expire = missExpire;
            }
            if (!RedisKey.DISABLE_MISS_VALUE.equals(expire)) {
                this.redisRepository.writeRedis(key, expire, proceed);
            }
        }
        return proceed;
    }

    private Object doHandleOne2OneCache(ProceedingJoinPoint joinPoint, String key, long expire, Class<?> returnType, CacheService cacheService, long missExpire) throws Throwable {
        Object objectFromLocalCache = cacheService.getObjectFromCache(key, returnType);
        if (objectFromLocalCache != null) {
            return objectFromLocalCache;
        }
        Object proceed = joinPoint.proceed();
        if (proceed == null) {
            proceed = this.buildEmptyObject(returnType);
            expire = missExpire;
        }
        if (!RedisKey.DISABLE_MISS_VALUE.equals(expire)) {
            this.redisRepository.writeRedis(key, expire, proceed);
        }
        return proceed;
    }

    private void doHandleListCache(List<Object> inputList, Class<?> clazz, Map<Object, ?> objectFromLocalCache, ProceedingJoinPoint joinPoint, String prefix, long expire, UnaryOperator<Object> emptyCallback, Object[] args, long missExpire) throws Throwable {
        List dbMissingList;
        List cacheMissList = inputList.stream().filter(key -> !objectFromLocalCache.containsKey(key)).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(cacheMissList)) {
            return;
        }
        ArrayList params = new ArrayList();
        params.add(cacheMissList);
        IntStream.range(1, args.length).forEach(index -> params.add(args[index]));
        Map result = (Map)joinPoint.proceed(params.toArray());
        if (MapUtil.isEmpty((Map)result)) {
            dbMissingList = cacheMissList;
        } else {
            dbMissingList = cacheMissList.stream().filter(key -> !result.containsKey(key)).collect(Collectors.toList());
            HashMap<String, Object> keyValues = new HashMap<String, Object>(result.size());
            result.forEach((k, v) -> keyValues.put(String.format(prefix, k), v));
            this.redisRepository.batchWriteRedis(keyValues, expire);
            objectFromLocalCache.putAll(result);
        }
        if (CollectionUtils.isEmpty(dbMissingList)) {
            return;
        }
        if (!RedisKey.DISABLE_MISS_VALUE.equals(missExpire)) {
            Map<String, Object> emptyMissData = dbMissingList.stream().collect(Collectors.toMap(key -> String.format(prefix, key), key -> emptyCallback.apply(clazz)));
            this.redisRepository.batchWriteRedis(emptyMissData, missExpire);
        }
    }

    private Object buildEmptyObject(Class<?> clazz) {
        Object empty = null;
        try {
            Method emptyMethod = clazz.getMethod("emptyObject", new Class[0]);
            empty = emptyMethod.invoke(null, new Object[0]);
        }
        catch (Exception e) {
            log.warn("call static emptyObject error, className:{}", (Object)clazz.getName());
        }
        return empty == null ? "{\"id\":-1}" : JSON.toJSONString(empty);
    }
}

