/*
 * Decompiled with CFR 0.152.
 */
package cn.soboys.simplestjpa;

import cn.soboys.simplestjpa.BaseRepository;
import cn.soboys.simplestjpa.exception.UpdateException;
import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Predicate;
import com.querydsl.jpa.impl.JPAQuery;
import com.querydsl.jpa.impl.JPAQueryFactory;
import com.querydsl.jpa.impl.JPAUpdateClause;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import javax.persistence.EntityManager;
import org.dromara.hutool.core.array.ArrayUtil;
import org.dromara.hutool.core.bean.BeanUtil;
import org.dromara.hutool.core.bean.copier.CopyOptions;
import org.dromara.hutool.core.collection.CollUtil;
import org.dromara.hutool.core.exception.ExceptionUtil;
import org.dromara.hutool.core.text.StrUtil;
import org.springframework.data.domain.Example;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.jpa.repository.support.JpaEntityInformation;
import org.springframework.data.jpa.repository.support.JpaEntityInformationSupport;
import org.springframework.transaction.annotation.Transactional;

public interface IService<T, ID extends Serializable> {
    public static final int DEFAULT_BATCH_SIZE = 1000;

    public BaseRepository<T, ID> getRepository();

    public JPAQueryFactory getJPAQueryFactory();

    public JPAQuery queryChain();

    public JPAUpdateClause updateChain(EntityPath var1);

    public EntityManager getEntityManager();

    default public T save(T entity) {
        return (T)this.getRepository().save(entity);
    }

    default public List<T> saveBatch(Collection<T> entities) {
        return this.getRepository().saveAll(entities);
    }

    @Transactional
    default public T update(T entity, Object ... ignore) {
        JpaEntityInformation entityInformation = JpaEntityInformationSupport.getEntityInformation(entity.getClass(), (EntityManager)this.getEntityManager());
        entityInformation.getRequiredId(entity);
        return (T)this.getEntityManager().merge(entity);
    }

    @Transactional
    default public T update(T entity, Boolean ignore) {
        JpaEntityInformation entityInformation = JpaEntityInformationSupport.getEntityInformation(entity.getClass(), (EntityManager)this.getEntityManager());
        entityInformation.getRequiredId(entity);
        if (!ignore.booleanValue()) {
            return (T)this.getEntityManager().merge(entity);
        }
        if (ignore.booleanValue()) {
            Object id = entityInformation.getId(entity);
            Object existingEntity = this.getRepository().findById((Serializable)id).orElseThrow(() -> new IllegalArgumentException("Entity not found"));
            CopyOptions copyOptions = new CopyOptions();
            copyOptions.setIgnoreCase(false);
            copyOptions.setIgnoreNullValue(true);
            Map stringObjectMap = BeanUtil.beanToMap(entity, (boolean)true, (boolean)true);
            String[] IgnoreProperties = stringObjectMap.keySet().toArray(new String[0]);
            copyOptions.setIgnoreProperties(IgnoreProperties);
            BeanUtil.copyProperties(existingEntity, entity, (CopyOptions)copyOptions);
            return (T)this.getEntityManager().merge(entity);
        }
        return (T)this.getEntityManager().merge(entity);
    }

    @Transactional
    default public T update(T entity, Boolean ignore, String[] ignoreProperties) {
        JpaEntityInformation entityInformation = JpaEntityInformationSupport.getEntityInformation(entity.getClass(), (EntityManager)this.getEntityManager());
        entityInformation.getRequiredId(entity);
        if (!ignore.booleanValue()) {
            return (T)this.getEntityManager().merge(entity);
        }
        if (ignore.booleanValue()) {
            Object id = entityInformation.getId(entity);
            Object existingEntity = this.getRepository().findById((Serializable)id).orElseThrow(() -> new IllegalArgumentException("Entity not found"));
            CopyOptions copyOptions = new CopyOptions();
            copyOptions.setIgnoreCase(false);
            copyOptions.setIgnoreNullValue(true);
            Map stringObjectMap = BeanUtil.beanToMap(entity, (boolean)true, (boolean)true);
            String[] entityIgnoreProperties = stringObjectMap.keySet().toArray(new String[0]);
            String[] CustomIgnoreProperties = (String[])ArrayUtil.addAll((Object[][])new String[][]{entityIgnoreProperties, ignoreProperties});
            copyOptions.setIgnoreProperties(CustomIgnoreProperties);
            BeanUtil.copyProperties(existingEntity, entity, (CopyOptions)copyOptions);
            return (T)this.getEntityManager().merge(entity);
        }
        return (T)this.getEntityManager().merge(entity);
    }

    @Transactional
    default public T saveOrUpdate(T entity) {
        JpaEntityInformation entityInformation = JpaEntityInformationSupport.getEntityInformation(entity.getClass(), (EntityManager)this.getEntityManager());
        if (entityInformation.isNew(entity)) {
            this.getEntityManager().persist(entity);
            return entity;
        }
        return (T)this.getEntityManager().merge(entity);
    }

    @Transactional
    default public boolean update(JPAUpdateClause query) {
        long count = query.execute();
        return count > 0L;
    }

    default public long count() {
        return this.getRepository().count();
    }

    default public long count(Example<T> example) {
        return this.getRepository().count(example);
    }

    default public T getById(ID id) {
        return this.getRepository().findById(id).get();
    }

    default public Optional<T> getByIdOpt(ID id) {
        return this.getRepository().findById(id);
    }

    default public Optional<T> getOneOpt(Example<T> example) {
        return this.getRepository().findOne(example);
    }

    default public T getOne(Example<T> example) {
        return this.getRepository().findOne(example).get();
    }

    default public T getOne(Predicate query) {
        return this.getRepository().findOne(query).get();
    }

    default public long count(Predicate query) {
        return this.getRepository().count(query);
    }

    default public boolean exists(Predicate query) {
        return this.getRepository().exists(query);
    }

    default public boolean exists(Example condition) {
        return this.getRepository().exists(condition);
    }

    default public boolean existsById(ID id) {
        return this.getRepository().existsById(id);
    }

    default public List<T> list() {
        return this.getRepository().findAll();
    }

    default public List<T> list(Predicate query) {
        return StreamSupport.stream(this.getRepository().findAll(query).spliterator(), false).collect(Collectors.toList());
    }

    default public List<T> list(Example query) {
        return this.getRepository().findAll(query);
    }

    default public List<T> listByIds(Collection<ID> ids) {
        return this.getRepository().findAllById(ids);
    }

    default public Page<T> page(Pageable page) {
        return this.getRepository().findAll(page);
    }

    default public Page<T> page(Pageable page, Predicate query) {
        return this.getRepository().findAll(query, page);
    }

    default public boolean removeById(ID id) {
        boolean success = true;
        if (StrUtil.isBlankIfStr(id)) {
            return false;
        }
        try {
            this.getRepository().deleteById(id);
        }
        catch (Exception e) {
            success = false;
            new UpdateException(ExceptionUtil.stacktraceToString((Throwable)e));
        }
        return success;
    }

    default public boolean removeByIds(Collection<? extends ID> ids) {
        boolean success = true;
        if (CollUtil.isEmpty(ids)) {
            return false;
        }
        try {
            this.getRepository().deleteAllById(ids);
        }
        catch (Exception e) {
            success = false;
            new UpdateException(ExceptionUtil.stacktraceToString((Throwable)e));
        }
        return success;
    }

    default public boolean remove(T entity) {
        boolean success = true;
        try {
            this.getRepository().delete(entity);
        }
        catch (Exception e) {
            success = false;
            new UpdateException(ExceptionUtil.stacktraceToString((Throwable)e));
        }
        return success;
    }

    default public boolean remove(Collection<T> entities) {
        boolean success = true;
        if (CollUtil.isEmpty(entities)) {
            return false;
        }
        try {
            this.getRepository().deleteAllInBatch(entities);
        }
        catch (Exception e) {
            success = false;
            new UpdateException(ExceptionUtil.stacktraceToString((Throwable)e));
        }
        return success;
    }

    default public boolean removeAll(Collection<? extends T> entities) {
        boolean success = true;
        if (CollUtil.isEmpty(entities)) {
            return false;
        }
        try {
            this.getRepository().deleteAll(entities);
        }
        catch (Exception e) {
            success = false;
            new UpdateException(ExceptionUtil.stacktraceToString((Throwable)e));
        }
        return success;
    }

    default public boolean remove() {
        boolean success = true;
        try {
            this.getRepository().deleteAll();
        }
        catch (Exception e) {
            success = false;
            new UpdateException(ExceptionUtil.stacktraceToString((Throwable)e));
        }
        return success;
    }
}

