/*
 * Decompiled with CFR 0.152.
 */
package cn.soboys.restapispringbootstarter.utils;

import cn.soboys.restapispringbootstarter.utils.HttpUserAgent;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Method;
import java.net.URLDecoder;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.dromara.hutool.core.map.MapUtil;
import org.dromara.hutool.json.JSON;
import org.dromara.hutool.json.JSONObject;
import org.dromara.hutool.json.JSONUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

public class RequestUtil {
    private static final Logger log = LoggerFactory.getLogger(RequestUtil.class);

    public static HttpServletRequest getReq() {
        ServletRequestAttributes attributes = (ServletRequestAttributes)RequestContextHolder.getRequestAttributes();
        HttpServletRequest httpServletRequest = null;
        if (attributes != null) {
            httpServletRequest = attributes.getRequest();
        }
        return httpServletRequest;
    }

    public static JSON getParam(HttpServletRequest request) throws IOException {
        BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)request.getInputStream()));
        String str = "";
        StringBuffer wholeStr = new StringBuffer();
        while ((str = reader.readLine()) != null) {
            wholeStr.append(str);
        }
        String text = wholeStr.toString();
        if (StringUtils.isBlank((CharSequence)text)) {
            return new JSONObject();
        }
        if (StringUtils.startsWith((CharSequence)text, (CharSequence)"[")) {
            return JSONUtil.parseArray((Object)text);
        }
        return JSONUtil.parseObj((Object)text);
    }

    public static JSON getRequestParams(HttpServletRequest request) throws IOException {
        JSONObject jsonObject = new JSONObject();
        Map parameterMap = request.getParameterMap();
        if (MapUtil.isNotEmpty((Map)parameterMap)) {
            parameterMap.forEach((key, value) -> jsonObject.put(key, (Object)value[0]));
            return jsonObject;
        }
        return RequestUtil.getParam(request);
    }

    public static String getValue(HttpServletRequest request, String name) {
        Cookie[] cookies;
        String value = request.getHeader(name);
        if (value == null) {
            value = request.getParameter(name);
        }
        if (value == null && (cookies = request.getCookies()) != null && cookies.length > 0) {
            for (Cookie cookie : cookies) {
                if (!cookie.getName().equals(name)) continue;
                value = cookie.getValue();
                try {
                    value = URLDecoder.decode(value, "UTF-8");
                }
                catch (UnsupportedEncodingException e) {
                    log.error("Cookie \u89e3\u7801\u5931\u8d25\uff0c\u7f16\u7801=UTF-8\uff0c\u503c=" + value);
                }
                break;
            }
        }
        return value;
    }

    public static boolean hasAjaxRequest() {
        return RequestUtil.hasAjaxRequest(RequestUtil.getReq());
    }

    public static boolean hasLocalRequest() {
        return "127.0.0.1".endsWith(HttpUserAgent.getIpAddr());
    }

    public static String getHost() {
        HttpServletRequest request = RequestUtil.getReq();
        return request.getServerName() + (request.getServerPort() == 80 ? "" : ":" + request.getServerPort());
    }

    public static String getHttpUrl(String ... names) {
        return RequestUtil.getHttpUrl(RequestUtil.getReq(), names);
    }

    private static String getHttpUrl(HttpServletRequest request, String ... names) {
        String httpUrl = request.getScheme() + "://" + request.getServerName() + (request.getServerPort() == 80 ? "" : ":" + request.getServerPort());
        if (names != null) {
            for (String name : names) {
                httpUrl = httpUrl + "/" + (name.startsWith("/") ? name.substring(1) : name);
            }
        }
        return httpUrl;
    }

    public static boolean hasAjaxRequest(HttpServletRequest request) {
        String requestedWith = request.getHeader("x-requested-with");
        return requestedWith != null && requestedWith.equalsIgnoreCase("XMLHttpRequest");
    }

    public static String getParam(String url, String name) {
        return RequestUtil.urlSplit(url).get(name);
    }

    private static String truncateUrlPage(String url) {
        String strAllParam = null;
        String[] arrSplit = null;
        url = url.trim().toLowerCase();
        arrSplit = url.split("[?]");
        if (url.length() > 1 && arrSplit.length > 1) {
            for (int i = 1; i < arrSplit.length; ++i) {
                strAllParam = arrSplit[i];
            }
        }
        return strAllParam;
    }

    public static Map<String, String> urlSplit(String url) {
        HashMap<String, String> mapRequest = new HashMap<String, String>();
        String[] arrSplit = null;
        String strUrlParam = RequestUtil.truncateUrlPage(url);
        if (strUrlParam == null) {
            return mapRequest;
        }
        for (String strSplit : arrSplit = strUrlParam.split("[&]")) {
            String[] arrSplitEqual = null;
            arrSplitEqual = strSplit.split("[=]");
            if (arrSplitEqual.length > 1) {
                mapRequest.put(arrSplitEqual[0], arrSplitEqual[1]);
                continue;
            }
            if (arrSplitEqual[0] == "") continue;
            mapRequest.put(arrSplitEqual[0], "");
        }
        return mapRequest;
    }

    public static class WebRequest<T> {
        private T request;

        public WebRequest(T request) {
            this.request = request;
        }

        public String getParameter(String paramName) {
            try {
                Method method = this.request.getClass().getMethod("getParameter", String.class);
                Object value = method.invoke(this.request, paramName);
                return (String)value;
            }
            catch (Exception e) {
                return null;
            }
        }

        public Map<String, String[]> getParameterMap() {
            try {
                Method method = this.request.getClass().getMethod("getParameterMap", new Class[0]);
                Object value = method.invoke(this.request, new Object[0]);
                return (Map)value;
            }
            catch (Exception e) {
                return null;
            }
        }
    }
}

