/*
 * Decompiled with CFR 0.152.
 */
package cn.soboys.restapispringbootstarter.serializer;

import cn.soboys.restapispringbootstarter.config.RestApiProperties;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import java.io.IOException;
import java.time.LocalDateTime;
import java.time.ZoneId;
import org.dromara.hutool.core.date.DateUtil;
import org.springframework.beans.factory.annotation.Autowired;

public class LocalDateTimeSerializer
extends JsonSerializer<LocalDateTime> {
    @Autowired
    private RestApiProperties.JsonSerializeProperties jsonSerializeProperties;

    public void serialize(LocalDateTime value, JsonGenerator jgen, SerializerProvider serializerProvider) throws IOException {
        if (this.jsonSerializeProperties.getDateForm().equals("timestamp")) {
            jgen.writeString(String.valueOf(value.atZone(ZoneId.systemDefault()).toInstant().toEpochMilli()));
        } else {
            jgen.writeString(DateUtil.format((LocalDateTime)value, (String)this.jsonSerializeProperties.getDateForm()));
        }
    }
}

