/*
 * Decompiled with CFR 0.152.
 */
package cn.soboys.restapispringbootstarter.serializer;

import cn.soboys.restapispringbootstarter.config.RestApiProperties;
import cn.soboys.restapispringbootstarter.serializer.BeanSerializerModifierFactory;
import cn.soboys.restapispringbootstarter.serializer.BigDecimalSerializer;
import cn.soboys.restapispringbootstarter.serializer.DateSerializer;
import cn.soboys.restapispringbootstarter.serializer.DoubleValueSerializer;
import cn.soboys.restapispringbootstarter.serializer.LocalDateTimeSerializer;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.fasterxml.jackson.databind.ser.BeanSerializerModifier;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.Date;
import org.springframework.context.annotation.Bean;

@JsonInclude(value=JsonInclude.Include.ALWAYS)
public class JsonSerializerConfig {
    @Bean
    public RestApiProperties.JsonSerializeProperties jsonSerializeProperties() {
        return new RestApiProperties.JsonSerializeProperties();
    }

    @Bean
    public DoubleValueSerializer doubleValueSerializer() {
        return new DoubleValueSerializer();
    }

    @Bean
    public BigDecimalSerializer bigDecimalSerializer() {
        return new BigDecimalSerializer();
    }

    @Bean
    public DateSerializer dateSerializer() {
        return new DateSerializer();
    }

    @Bean
    public LocalDateTimeSerializer localDateSerializer() {
        return new LocalDateTimeSerializer();
    }

    @Bean
    public BeanSerializerModifierFactory beanSerializerModifierFactory() {
        return new BeanSerializerModifierFactory();
    }

    @Bean
    public ObjectMapper objectMapper(DoubleValueSerializer doubleValueSerializer, BigDecimalSerializer bigDecimalSerializer, DateSerializer dateSerializer, BeanSerializerModifierFactory beanSerializerModifierFactory, LocalDateTimeSerializer localDateSerializer) {
        ObjectMapper objectMapper = new ObjectMapper();
        SimpleModule module = new SimpleModule();
        module.addSerializer(Double.class, (JsonSerializer)doubleValueSerializer);
        module.addSerializer(BigDecimal.class, (JsonSerializer)bigDecimalSerializer);
        module.addSerializer(Date.class, (JsonSerializer)dateSerializer);
        module.addSerializer(LocalDateTime.class, (JsonSerializer)localDateSerializer);
        objectMapper.registerModule((Module)module);
        objectMapper.setSerializerFactory(objectMapper.getSerializerFactory().withSerializerModifier((BeanSerializerModifier)beanSerializerModifierFactory));
        return objectMapper;
    }
}

