/*
 * Decompiled with CFR 0.152.
 */
package cn.soboys.restapispringbootstarter.i18n;

import cn.soboys.restapispringbootstarter.i18n.I18NKey;
import java.util.Map;
import java.util.Optional;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.annotation.Configuration;

@Configuration
@ConfigurationProperties(prefix="rest-api.i18n")
public class I18NMessage {
    private Map<String, Map<String, String>> message;
    private String defaultLang = "cn";
    private String i18nHeader = "Lang";

    public String message(I18NKey key, String language) {
        return Optional.ofNullable(this.message.get(key.key())).map(map -> (String)map.get(language == null ? this.defaultLang : language)).orElse(key.key());
    }

    public String message(String key, String language) {
        return Optional.ofNullable(this.message.get(key)).map(map -> (String)map.get(language == null ? this.defaultLang : language)).orElse(key);
    }

    public Map<String, Map<String, String>> getMessage() {
        return this.message;
    }

    public String getDefaultLang() {
        return this.defaultLang;
    }

    public String getI18nHeader() {
        return this.i18nHeader;
    }

    public void setMessage(Map<String, Map<String, String>> message) {
        this.message = message;
    }

    public void setDefaultLang(String defaultLang) {
        this.defaultLang = defaultLang;
    }

    public void setI18nHeader(String i18nHeader) {
        this.i18nHeader = i18nHeader;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof I18NMessage)) {
            return false;
        }
        I18NMessage other = (I18NMessage)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Map<String, Map<String, String>> this$message = this.getMessage();
        Map<String, Map<String, String>> other$message = other.getMessage();
        if (this$message == null ? other$message != null : !((Object)this$message).equals(other$message)) {
            return false;
        }
        String this$defaultLang = this.getDefaultLang();
        String other$defaultLang = other.getDefaultLang();
        if (this$defaultLang == null ? other$defaultLang != null : !this$defaultLang.equals(other$defaultLang)) {
            return false;
        }
        String this$i18nHeader = this.getI18nHeader();
        String other$i18nHeader = other.getI18nHeader();
        return !(this$i18nHeader == null ? other$i18nHeader != null : !this$i18nHeader.equals(other$i18nHeader));
    }

    protected boolean canEqual(Object other) {
        return other instanceof I18NMessage;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Map<String, Map<String, String>> $message = this.getMessage();
        result = result * 59 + ($message == null ? 43 : ((Object)$message).hashCode());
        String $defaultLang = this.getDefaultLang();
        result = result * 59 + ($defaultLang == null ? 43 : $defaultLang.hashCode());
        String $i18nHeader = this.getI18nHeader();
        result = result * 59 + ($i18nHeader == null ? 43 : $i18nHeader.hashCode());
        return result;
    }

    public String toString() {
        return "I18NMessage(message=" + this.getMessage() + ", defaultLang=" + this.getDefaultLang() + ", i18nHeader=" + this.getI18nHeader() + ")";
    }
}

