/*
 * Decompiled with CFR 0.152.
 */
package cn.soboys.restapispringbootstarter.cache;

import cn.soboys.restapispringbootstarter.config.RestApiProperties;
import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.PropertyAccessor;
import com.fasterxml.jackson.databind.ObjectMapper;
import org.dromara.hutool.core.text.StrUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.data.redis.connection.RedisConnectionFactory;
import org.springframework.data.redis.core.RedisOperations;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.data.redis.serializer.Jackson2JsonRedisSerializer;
import org.springframework.data.redis.serializer.RedisSerializer;
import org.springframework.data.redis.serializer.SerializationException;
import org.springframework.data.redis.serializer.StringRedisSerializer;

@Configuration
public class RedisConfig {
    @Autowired
    private RestApiProperties.RedisProperties redisProperties;

    @Bean
    @ConditionalOnClass(value={RedisOperations.class})
    public RedisTemplate<String, Object> redisTemplate(RedisConnectionFactory factory) {
        RedisTemplate template = new RedisTemplate();
        template.setConnectionFactory(factory);
        Jackson2JsonRedisSerializer jackson2JsonRedisSerializer = new Jackson2JsonRedisSerializer(Object.class);
        ObjectMapper mapper = new ObjectMapper();
        mapper.setVisibility(PropertyAccessor.ALL, JsonAutoDetect.Visibility.ANY);
        mapper.activateDefaultTyping(mapper.getPolymorphicTypeValidator(), ObjectMapper.DefaultTyping.NON_FINAL);
        jackson2JsonRedisSerializer.setObjectMapper(mapper);
        StringRedisSerializer stringRedisSerializer = new StringRedisSerializer();
        if (this.redisProperties != null && StrUtil.isNotEmpty((CharSequence)this.redisProperties.getKeyPrefix())) {
            template.setKeySerializer((RedisSerializer)new PrefixStringRedisSerializer(this.redisProperties.getKeyPrefix() + ":", stringRedisSerializer));
            template.setHashKeySerializer((RedisSerializer)new PrefixStringRedisSerializer(this.redisProperties.getKeyPrefix() + ":", stringRedisSerializer));
        } else {
            template.setKeySerializer((RedisSerializer)stringRedisSerializer);
            template.setHashKeySerializer((RedisSerializer)stringRedisSerializer);
        }
        template.setValueSerializer((RedisSerializer)jackson2JsonRedisSerializer);
        template.setHashValueSerializer((RedisSerializer)jackson2JsonRedisSerializer);
        template.afterPropertiesSet();
        return template;
    }

    public class PrefixStringRedisSerializer
    implements RedisSerializer<String> {
        private final String prefix;
        private final StringRedisSerializer serializer;

        public PrefixStringRedisSerializer(String prefix, StringRedisSerializer serializer) {
            this.prefix = prefix;
            this.serializer = serializer;
        }

        public byte[] serialize(String s) throws SerializationException {
            return this.serializer.serialize(this.prefix + s);
        }

        public String deserialize(byte[] bytes) throws SerializationException {
            String key = this.serializer.deserialize(bytes);
            if (key != null && key.startsWith(this.prefix)) {
                return key.substring(this.prefix.length());
            }
            return key;
        }
    }
}

