/*
 * Decompiled with CFR 0.152.
 */
package cn.soboys.restapispringbootstarter.authorization;

import cn.soboys.restapispringbootstarter.Assert;
import cn.soboys.restapispringbootstarter.HttpStatus;
import cn.soboys.restapispringbootstarter.authorization.UserSign;
import cn.soboys.restapispringbootstarter.config.RestApiProperties;
import cn.soboys.restapispringbootstarter.exception.BusinessException;
import cn.soboys.restapispringbootstarter.utils.JwtUtil;
import io.jsonwebtoken.Claims;
import io.jsonwebtoken.ExpiredJwtException;
import io.jsonwebtoken.Jws;
import io.jsonwebtoken.MalformedJwtException;
import io.jsonwebtoken.SignatureException;
import java.util.LinkedHashMap;
import org.dromara.hutool.core.bean.BeanUtil;
import org.dromara.hutool.core.text.StrUtil;
import org.dromara.hutool.extra.spring.SpringUtil;

public class UserJwtToken {
    public Boolean rememberMe = Boolean.FALSE;
    private UserSign userSign;
    private RestApiProperties.JwtProperties jwtProperties = (RestApiProperties.JwtProperties)SpringUtil.getBean(RestApiProperties.JwtProperties.class);

    public String createdToken(String userId, String username, Object users) {
        String token = "";
        Long expiration = this.jwtProperties.getExpiration();
        if (this.rememberMe.booleanValue()) {
            expiration = this.jwtProperties.getRememberMeExpiration();
        }
        if (this.jwtProperties.getUserSign().booleanValue()) {
            Assert.notNull(this.userSign, HttpStatus.UNAUTHORIZED.getCode(), StrUtil.format((CharSequence)(HttpStatus.UNAUTHORIZED.getMessage() + " {}"), (Object[])new Object[]{"\u627e\u4e0d\u5230\u7b7e\u540d\u7c7b\u548c\u65b9\u6cd5"}));
            String key = this.userSign.AuthKey();
            if (StrUtil.isEmpty((CharSequence)key)) {
                key = this.jwtProperties.getSecret();
            }
            token = JwtUtil.createJWT(username, userId, users, expiration, this.userSign.sign(), key);
        } else {
            token = JwtUtil.createJWT(username, userId, users, expiration);
        }
        return token;
    }

    public <T> T parseUserToken(String userToken, Class<T> returnCls) {
        Jws<Claims> claims;
        try {
            if (this.jwtProperties.getUserSign().booleanValue()) {
                Assert.notNull(this.userSign, HttpStatus.UNAUTHORIZED.getCode(), StrUtil.format((CharSequence)(HttpStatus.UNAUTHORIZED.getMessage() + " {}"), (Object[])new Object[]{"\u627e\u4e0d\u5230\u7b7e\u540d\u7c7b\u548c\u65b9\u6cd5"}));
                String key = this.userSign.AuthKey();
                if (StrUtil.isEmpty((CharSequence)key)) {
                    key = this.jwtProperties.getSecret();
                }
                claims = JwtUtil.parseJWT(userToken, this.userSign.getSignedKey(key));
            } else {
                claims = JwtUtil.parseJWT(userToken);
            }
        }
        catch (ExpiredJwtException e) {
            throw new BusinessException(HttpStatus.UNAUTHORIZED_EXPIRED);
        }
        catch (SignatureException e) {
            throw new BusinessException("Token\u9a8c\u8bc1\u7b7e\u540d\u5bc6\u94a5\u4e0d\u6b63\u786e", HttpStatus.UNAUTHORIZED.getCode());
        }
        catch (MalformedJwtException e) {
            throw new BusinessException("Token\u65e0\u6548\u6216\u8005\u4e0d\u5b58\u5728", HttpStatus.UNAUTHORIZED.getCode());
        }
        LinkedHashMap linkedHashMap = (LinkedHashMap)((Claims)claims.getBody()).get("user", LinkedHashMap.class);
        return (T)BeanUtil.toBean((Object)linkedHashMap, returnCls);
    }

    public String getUserId(String userToken) {
        Claims claims = this.getClaims(userToken);
        return claims.getId();
    }

    public String getUserName(String userToken) {
        Claims claims = this.getClaims(userToken);
        return claims.getSubject();
    }

    public Jws<Claims> parseJWT(String jwt) {
        Jws<Claims> claimsJws;
        try {
            if (this.jwtProperties.getUserSign().booleanValue()) {
                Assert.notNull(this.userSign, HttpStatus.UNAUTHORIZED.getCode(), StrUtil.format((CharSequence)(HttpStatus.UNAUTHORIZED.getMessage() + " {}"), (Object[])new Object[]{"\u627e\u4e0d\u5230\u7b7e\u540d\u7c7b\u548c\u65b9\u6cd5"}));
                String key = this.userSign.AuthKey();
                if (StrUtil.isEmpty((CharSequence)key)) {
                    key = this.jwtProperties.getSecret();
                }
                claimsJws = JwtUtil.parseJWT(jwt, this.userSign.getSignedKey(key));
            } else {
                claimsJws = JwtUtil.parseJWT(jwt);
            }
        }
        catch (ExpiredJwtException e) {
            throw new BusinessException(HttpStatus.UNAUTHORIZED_EXPIRED);
        }
        catch (SignatureException e) {
            throw new BusinessException("Token\u9a8c\u8bc1\u7b7e\u540d\u5bc6\u94a5\u4e0d\u6b63\u786e", HttpStatus.UNAUTHORIZED.getCode());
        }
        catch (MalformedJwtException e) {
            throw new BusinessException("Token\u65e0\u6548\u6216\u8005\u4e0d\u5b58\u5728", HttpStatus.UNAUTHORIZED.getCode());
        }
        return claimsJws;
    }

    public Claims getClaims(String jwt) {
        Claims claims;
        try {
            if (this.jwtProperties.getUserSign().booleanValue()) {
                Assert.notNull(this.userSign, HttpStatus.UNAUTHORIZED.getCode(), StrUtil.format((CharSequence)(HttpStatus.UNAUTHORIZED.getMessage() + " {}"), (Object[])new Object[]{"\u627e\u4e0d\u5230\u7b7e\u540d\u7c7b\u548c\u65b9\u6cd5"}));
                String key = this.userSign.AuthKey();
                if (StrUtil.isEmpty((CharSequence)key)) {
                    key = this.jwtProperties.getSecret();
                }
                claims = JwtUtil.getClaims(jwt, this.userSign.getSignedKey(key));
            } else {
                claims = JwtUtil.getClaims(jwt);
            }
        }
        catch (ExpiredJwtException e) {
            throw new BusinessException(HttpStatus.UNAUTHORIZED_EXPIRED);
        }
        catch (SignatureException e) {
            throw new BusinessException("Token\u9a8c\u8bc1\u7b7e\u540d\u5bc6\u94a5\u4e0d\u6b63\u786e", HttpStatus.UNAUTHORIZED.getCode());
        }
        catch (MalformedJwtException e) {
            throw new BusinessException("Token\u65e0\u6548\u6216\u8005\u4e0d\u5b58\u5728", HttpStatus.UNAUTHORIZED.getCode());
        }
        return claims;
    }

    public Boolean getRememberMe() {
        return this.rememberMe;
    }

    public UserSign getUserSign() {
        return this.userSign;
    }

    public RestApiProperties.JwtProperties getJwtProperties() {
        return this.jwtProperties;
    }

    public void setRememberMe(Boolean rememberMe) {
        this.rememberMe = rememberMe;
    }

    public void setUserSign(UserSign userSign) {
        this.userSign = userSign;
    }

    public void setJwtProperties(RestApiProperties.JwtProperties jwtProperties) {
        this.jwtProperties = jwtProperties;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof UserJwtToken)) {
            return false;
        }
        UserJwtToken other = (UserJwtToken)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Boolean this$rememberMe = this.getRememberMe();
        Boolean other$rememberMe = other.getRememberMe();
        if (this$rememberMe == null ? other$rememberMe != null : !((Object)this$rememberMe).equals(other$rememberMe)) {
            return false;
        }
        UserSign this$userSign = this.getUserSign();
        UserSign other$userSign = other.getUserSign();
        if (this$userSign == null ? other$userSign != null : !this$userSign.equals(other$userSign)) {
            return false;
        }
        RestApiProperties.JwtProperties this$jwtProperties = this.getJwtProperties();
        RestApiProperties.JwtProperties other$jwtProperties = other.getJwtProperties();
        return !(this$jwtProperties == null ? other$jwtProperties != null : !((Object)this$jwtProperties).equals(other$jwtProperties));
    }

    protected boolean canEqual(Object other) {
        return other instanceof UserJwtToken;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Boolean $rememberMe = this.getRememberMe();
        result = result * 59 + ($rememberMe == null ? 43 : ((Object)$rememberMe).hashCode());
        UserSign $userSign = this.getUserSign();
        result = result * 59 + ($userSign == null ? 43 : $userSign.hashCode());
        RestApiProperties.JwtProperties $jwtProperties = this.getJwtProperties();
        result = result * 59 + ($jwtProperties == null ? 43 : ((Object)$jwtProperties).hashCode());
        return result;
    }

    public String toString() {
        return "UserJwtToken(rememberMe=" + this.getRememberMe() + ", userSign=" + this.getUserSign() + ", jwtProperties=" + this.getJwtProperties() + ")";
    }
}

