/*
 * Decompiled with CFR 0.152.
 */
package cn.soboys.restapispringbootstarter.utils;

import io.jsonwebtoken.Claims;
import io.jsonwebtoken.CompressionCodecs;
import io.jsonwebtoken.Jws;
import io.jsonwebtoken.Jwts;
import io.jsonwebtoken.SignatureAlgorithm;
import java.security.Key;
import java.util.Date;
import javax.crypto.spec.SecretKeySpec;
import javax.xml.bind.DatatypeConverter;

public class JwtUtil {
    public static String createJWT(String subject, String issue, Object claim, long ttlMillis) {
        Date now = new Date();
        Date exp = new Date(now.getTime() + ttlMillis * 1000L);
        String result = Jwts.builder().setSubject(subject).setIssuer(issue).setId(issue).setExpiration(exp).claim("user", claim).signWith(JwtUtil.getSignatureAlgorithm(), JwtUtil.getAuthKey()).compressWith(CompressionCodecs.DEFLATE).compact();
        return result;
    }

    public static String createJWT(String subject, String issue, Object claim, long ttlMillis, SignatureAlgorithm signatureAlgorithm, String key) {
        Date now = new Date();
        Date exp = new Date(now.getTime() + ttlMillis * 1000L);
        String result = Jwts.builder().setSubject(subject).setIssuer(issue).setId(issue).setExpiration(exp).claim("user", claim).signWith(signatureAlgorithm, key).compressWith(CompressionCodecs.DEFLATE).compact();
        return result;
    }

    public static Jws<Claims> parseJWT(String jwt) {
        Jws claims = Jwts.parser().setSigningKey(JwtUtil.getSignedKey()).parseClaimsJws(jwt);
        return claims;
    }

    public static Jws<Claims> parseJWT(String jwt, Key key) {
        Jws claims = Jwts.parser().setSigningKey(key).parseClaimsJws(jwt);
        return claims;
    }

    public static Claims getClaims(String jwt) {
        Claims claims = (Claims)Jwts.parser().setSigningKey(JwtUtil.getSignedKey()).parseClaimsJws(jwt).getBody();
        return claims;
    }

    public static Claims getClaims(String jwt, Key key) {
        Claims claims = (Claims)Jwts.parser().setSigningKey(key).parseClaimsJws(jwt).getBody();
        return claims;
    }

    private static Key getSignedKey() {
        byte[] apiKeySecretBytes = DatatypeConverter.parseBase64Binary((String)JwtUtil.getAuthKey());
        SecretKeySpec signingKey = new SecretKeySpec(apiKeySecretBytes, JwtUtil.getSignatureAlgorithm().getJcaName());
        return signingKey;
    }

    public static String getAuthKey() {
        String auth = "2af57b969bac152d";
        return auth;
    }

    private static SignatureAlgorithm getSignatureAlgorithm() {
        return SignatureAlgorithm.HS256;
    }
}

