/*
 * Decompiled with CFR 0.152.
 */
package cn.soboys.restapispringbootstarter.serializer;

import cn.soboys.restapispringbootstarter.config.RestApiProperties;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import java.io.IOException;
import java.math.BigDecimal;
import org.dromara.hutool.core.math.NumberUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class BigDecimalSerializer
extends JsonSerializer<BigDecimal> {
    private static final Logger log = LoggerFactory.getLogger(BigDecimalSerializer.class);
    @Autowired
    private RestApiProperties.JsonSerializeProperties jsonSerializeProperties;

    public void serialize(BigDecimal value, JsonGenerator jgen, SerializerProvider serializerProvider) throws IOException {
        if (value != null) {
            jgen.writeString(NumberUtil.format((String)this.jsonSerializeProperties.getNumberForm(), (Object)value));
        } else {
            jgen.writeString("0.00");
        }
    }
}

