/*
 * Decompiled with CFR 0.152.
 */
package cn.soboys.restapispringbootstarter.serializer;

import cn.soboys.restapispringbootstarter.config.RestApiProperties;
import cn.soboys.restapispringbootstarter.serializer.NullAbleSerializer;
import cn.soboys.restapispringbootstarter.serializer.SerializableType;
import com.fasterxml.jackson.databind.BeanDescription;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializationConfig;
import com.fasterxml.jackson.databind.ser.BeanPropertyWriter;
import com.fasterxml.jackson.databind.ser.BeanSerializerModifier;
import java.math.BigDecimal;
import java.util.Date;
import java.util.List;
import java.util.Set;
import org.dromara.hutool.core.text.StrUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.context.properties.EnableConfigurationProperties;

@EnableConfigurationProperties(value={RestApiProperties.JsonSerializeProperties.class})
public class BeanSerializerModifierFactory
extends BeanSerializerModifier {
    @Autowired
    private RestApiProperties.JsonSerializeProperties jsonSerializeProperties;

    public List<BeanPropertyWriter> changeProperties(SerializationConfig config, BeanDescription beanDesc, List<BeanPropertyWriter> beanProperties) {
        if (!this.jsonSerializeProperties.getNullAble().getHasNullAble().booleanValue()) {
            return beanProperties;
        }
        for (int i = 0; i < beanProperties.size(); ++i) {
            BeanPropertyWriter writer = beanProperties.get(i);
            SerializableType type = new SerializableType();
            RestApiProperties.NullAble nullAble = this.jsonSerializeProperties.getNullAble();
            if (this.isArrayType(writer)) {
                type.setType(nullAble.getArrayType());
            } else if (this.isIntegerType(writer)) {
                type.setType(nullAble.getNumberType());
            } else if (this.isStringType(writer)) {
                type.setType(nullAble.getObjectType());
            } else if (this.isDoubleType(writer)) {
                type.setType(nullAble.getDoubleType());
            }
            if (!StrUtil.isNotEmpty((CharSequence)type.getType()) || type.getType().equals("original")) continue;
            NullAbleSerializer nullAbleSerializer = new NullAbleSerializer();
            nullAbleSerializer.setSerializableType(type);
            writer.assignNullSerializer((JsonSerializer)nullAbleSerializer);
        }
        return beanProperties;
    }

    protected boolean isArrayType(BeanPropertyWriter writer) {
        Class clazz = writer.getPropertyType();
        return clazz.isArray() || clazz.equals(List.class) || clazz.equals(Set.class);
    }

    protected boolean isStringType(BeanPropertyWriter writer) {
        Class clazz = writer.getPropertyType();
        return clazz.equals(String.class) || clazz.equals(Date.class);
    }

    protected boolean isIntegerType(BeanPropertyWriter writer) {
        Class clazz = writer.getPropertyType();
        return clazz.equals(Integer.class) || clazz.equals(Integer.TYPE) || clazz.equals(Long.class) || clazz.equals(Long.TYPE);
    }

    protected boolean isDoubleType(BeanPropertyWriter writer) {
        Class clazz = writer.getPropertyType();
        return clazz.equals(Double.class) || clazz.equals(BigDecimal.class) || clazz.equals(Float.class);
    }
}

