/*
 * Decompiled with CFR 0.152.
 */
package cn.soboys.restapispringbootstarter.config;

import cn.soboys.restapispringbootstarter.config.RestApiProperties;
import io.swagger.v3.oas.models.OpenAPI;
import io.swagger.v3.oas.models.info.Contact;
import io.swagger.v3.oas.models.info.Info;
import org.dromara.hutool.core.text.StrUtil;
import org.springdoc.core.GroupedOpenApi;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;

@EnableConfigurationProperties(value={RestApiProperties.OpenApiProperties.class})
public class OpenApiConfig {
    @Autowired
    private RestApiProperties.OpenApiProperties openApiProperties;

    @Bean
    public OpenAPI openApi() {
        Info info = new Info();
        Contact contact = new Contact();
        if (this.openApiProperties != null) {
            if (StrUtil.isNotEmpty((CharSequence)this.openApiProperties.getTitle())) {
                info.setTitle(this.openApiProperties.getTitle());
            }
            if (StrUtil.isNotEmpty((CharSequence)this.openApiProperties.getDescription())) {
                info.setTitle(this.openApiProperties.getDescription());
            }
            if (this.openApiProperties.getContact() != null) {
                if (StrUtil.isNotEmpty((CharSequence)this.openApiProperties.getContact().getName())) {
                    contact.setName(this.openApiProperties.getContact().getName());
                }
                if (StrUtil.isNotEmpty((CharSequence)this.openApiProperties.getContact().getEmail())) {
                    contact.setEmail(this.openApiProperties.getContact().getEmail());
                }
                if (StrUtil.isNotEmpty((CharSequence)this.openApiProperties.getContact().getUrl())) {
                    contact.setUrl(this.openApiProperties.getContact().getUrl());
                }
            }
        }
        return new OpenAPI().info(info.contact(contact).version(this.openApiProperties.getVersion()));
    }

    @Bean
    @ConditionalOnMissingBean
    public GroupedOpenApi adminApi() {
        return GroupedOpenApi.builder().group("rest").packagesToScan(new String[]{"cn.soboys.restapispringbootstarter.controller"}).build();
    }
}

