/*
 * Decompiled with CFR 0.152.
 */
package cn.soboys.restapispringbootstarter.aop;

import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.util.ArrayList;
import java.util.HashMap;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.reflect.MethodSignature;
import org.springframework.core.LocalVariableTableParameterNameDiscoverer;
import org.springframework.expression.EvaluationContext;
import org.springframework.expression.spel.standard.SpelExpressionParser;
import org.springframework.expression.spel.support.StandardEvaluationContext;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;

public class BaseAspectSupport {
    public Method resolveMethod(ProceedingJoinPoint point) {
        MethodSignature signature = (MethodSignature)point.getSignature();
        Class<?> targetClass = point.getTarget().getClass();
        Method method = this.getDeclaredMethod(targetClass, signature.getName(), signature.getMethod().getParameterTypes());
        if (method == null) {
            throw new IllegalStateException("\u65e0\u6cd5\u89e3\u6790\u76ee\u6807\u65b9\u6cd5: " + signature.getMethod().getName());
        }
        return method;
    }

    public Object getParameter(Method method, Object[] args) {
        ArrayList<Object> argList = new ArrayList<Object>();
        Parameter[] parameters = method.getParameters();
        HashMap<String, Object> map = new HashMap<String, Object>();
        for (int i = 0; i < parameters.length; ++i) {
            RequestBody requestBody = parameters[i].getAnnotation(RequestBody.class);
            RequestParam requestParam = parameters[i].getAnnotation(RequestParam.class);
            String key = parameters[i].getName();
            if (requestBody != null) {
                argList.add(args[i]);
                continue;
            }
            if (requestParam != null) {
                map.put(key, args[i]);
                continue;
            }
            map.put(key, args[i]);
        }
        if (map.size() > 0) {
            argList.add(map);
        }
        if (argList.size() == 0) {
            return null;
        }
        if (argList.size() == 1) {
            return argList.get(0);
        }
        return argList;
    }

    public Method getDeclaredMethod(Class<?> clazz, String name, Class<?> ... parameterTypes) {
        try {
            return clazz.getDeclaredMethod(name, parameterTypes);
        }
        catch (NoSuchMethodException e) {
            Class<?> superClass = clazz.getSuperclass();
            if (superClass != null) {
                return this.getDeclaredMethod(superClass, name, parameterTypes);
            }
            return null;
        }
    }

    public String parseExpression(String expressionString, Method method, Object[] args) {
        LocalVariableTableParameterNameDiscoverer discoverer = new LocalVariableTableParameterNameDiscoverer();
        String[] paramNameArr = discoverer.getParameterNames(method);
        SpelExpressionParser parser = new SpelExpressionParser();
        StandardEvaluationContext context = new StandardEvaluationContext();
        for (int i = 0; i < paramNameArr.length; ++i) {
            context.setVariable(paramNameArr[i], args[i]);
        }
        String result = (String)parser.parseExpression(expressionString).getValue((EvaluationContext)context, String.class);
        return result;
    }
}

