/*
 * Decompiled with CFR 0.152.
 */
package cn.soboys.restapispringbootstarter;

import cn.soboys.restapispringbootstarter.Result;
import cn.soboys.restapispringbootstarter.ResultPage;
import cn.soboys.restapispringbootstarter.annotation.NoRestFulApi;
import cn.soboys.restapispringbootstarter.config.RestApiProperties;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import org.dromara.hutool.core.array.ArrayUtil;
import org.dromara.hutool.core.bean.BeanUtil;
import org.dromara.hutool.core.text.StrUtil;
import org.dromara.hutool.extra.spring.SpringUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.core.MethodParameter;
import org.springframework.http.MediaType;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.http.server.ServerHttpRequest;
import org.springframework.http.server.ServerHttpResponse;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.servlet.mvc.method.annotation.ResponseBodyAdvice;

@ControllerAdvice
@ConditionalOnWebApplication(type=ConditionalOnWebApplication.Type.SERVLET)
public class ResultHandler
implements ResponseBodyAdvice<Object> {
    private static final Logger log = LoggerFactory.getLogger(ResultHandler.class);
    @Autowired
    private RestApiProperties restApiProperties;

    public boolean supports(MethodParameter returnType, Class<? extends HttpMessageConverter<?>> converterType) {
        return this.userDefineWrapResult(returnType);
    }

    public Object beforeBodyWrite(Object body, MethodParameter returnType, MediaType selectedContentType, Class<? extends HttpMessageConverter<?>> selectedConverterType, ServerHttpRequest request, ServerHttpResponse response) {
        if (body instanceof Result) {
            return this.userDefinedResultKey((Result)body);
        }
        if (body == null) {
            return this.userDefinedResultKey(Result.buildSuccess());
        }
        if (body instanceof String) {
            return body;
        }
        return this.userDefinedResultKey(Result.buildSuccess(body));
    }

    private Object userDefinedResultKey(Result r) {
        LinkedHashMap<String, Object> resultMap = new LinkedHashMap<String, Object>();
        if (this.restApiProperties != null && r != null && this.restApiProperties.isEnabled()) {
            String keyCode = this.restApiProperties.getCode();
            String keyMsg = this.restApiProperties.getMsg();
            String keySuccess = this.restApiProperties.getSuccess();
            String keyData = this.restApiProperties.getData();
            String keyPreviousPage = this.restApiProperties.getPreviousPage();
            String keyNextPage = this.restApiProperties.getNextPage();
            String keyPageSize = this.restApiProperties.getPageSize();
            String keyHasNext = this.restApiProperties.getHasNext();
            String keyTotalPageSize = this.restApiProperties.getTotalPageSize();
            String keyPageData = this.restApiProperties.getPageData();
            String codeSuccessValue = this.restApiProperties.getCodeSuccessValue();
            if (StrUtil.isNotEmpty((CharSequence)keySuccess)) {
                resultMap.put(keySuccess, r.getSuccess());
            }
            if (StrUtil.isNotEmpty((CharSequence)keyCode)) {
                if (StrUtil.isNotEmpty((CharSequence)codeSuccessValue) && r.getCode().equals("OK")) {
                    resultMap.put(keyCode, this.restApiProperties.getCodeSuccessValue());
                } else {
                    resultMap.put(keyCode, r.getCode());
                }
            }
            if (StrUtil.isNotEmpty((CharSequence)keyMsg)) {
                resultMap.put(keyMsg, r.getMsg());
            }
            resultMap.put("requestId", r.getRequestId());
            resultMap.put("timestamp", r.getTimestamp());
            if (r.getData() != null && r.getData() instanceof ResultPage) {
                ResultPage resultPage = (ResultPage)r.getData();
                if (this.restApiProperties.getPageWrap().booleanValue()) {
                    LinkedHashMap<String, Object> dataMap = new LinkedHashMap<String, Object>();
                    if (StrUtil.isNotEmpty((CharSequence)keyPreviousPage)) {
                        dataMap.put(keyPreviousPage, resultPage.getPreviousPage());
                    }
                    if (StrUtil.isNotEmpty((CharSequence)keyNextPage)) {
                        dataMap.put(keyNextPage, resultPage.getNextPage());
                    }
                    if (StrUtil.isNotEmpty((CharSequence)keyPageSize)) {
                        dataMap.put(keyPageSize, resultPage.getPageSize());
                    }
                    if (StrUtil.isNotEmpty((CharSequence)keyHasNext)) {
                        dataMap.put(keyHasNext, resultPage.getHasNext());
                    }
                    if (StrUtil.isNotEmpty((CharSequence)keyTotalPageSize)) {
                        dataMap.put(keyTotalPageSize, resultPage.getTotalPageSize());
                    }
                    if (StrUtil.isNotEmpty((CharSequence)keyPageData)) {
                        dataMap.put(keyPageData, resultPage.getPageData());
                    }
                    resultMap.put(keyData, dataMap);
                    return resultMap;
                }
                if (StrUtil.isNotEmpty((CharSequence)keyPreviousPage)) {
                    resultMap.put(keyPreviousPage, resultPage.getPreviousPage());
                }
                if (StrUtil.isNotEmpty((CharSequence)keyNextPage)) {
                    resultMap.put(keyNextPage, resultPage.getNextPage());
                }
                if (StrUtil.isNotEmpty((CharSequence)keyPageSize)) {
                    resultMap.put(keyPageSize, resultPage.getPageSize());
                }
                if (StrUtil.isNotEmpty((CharSequence)keyHasNext)) {
                    resultMap.put(keyHasNext, resultPage.getHasNext());
                }
                if (StrUtil.isNotEmpty((CharSequence)keyTotalPageSize)) {
                    resultMap.put(keyTotalPageSize, resultPage.getTotalPageSize());
                }
                if (StrUtil.isNotEmpty((CharSequence)keyData)) {
                    resultMap.put(keyData, resultPage.getPageData());
                }
            } else if (StrUtil.isNotEmpty((CharSequence)keyData)) {
                resultMap.put(keyData, r.getData());
            }
            return resultMap;
        }
        if (r.getData() != null && r.getData() instanceof ResultPage) {
            if (this.restApiProperties.getPageWrap().booleanValue()) {
                Map dataMap = BeanUtil.beanToMap(r.getData(), (boolean)false, (boolean)true);
                dataMap.remove("requestId");
                dataMap.remove("timestamp");
                r.setData(dataMap);
                return r;
            }
            ResultPage resultPage = (ResultPage)r.getData();
            resultPage.setCode(r.getCode());
            resultPage.setMsg(r.getMsg());
            resultPage.setSuccess(r.getSuccess());
            resultPage.setTimestamp(r.getTimestamp());
            resultPage.setData(resultPage.getPageData());
            resultPage.setPageData(null);
            Map rPage = BeanUtil.beanToMap((Object)resultPage, (boolean)false, (boolean)true);
            return rPage;
        }
        return r;
    }

    private Boolean userDefineWrapResult(MethodParameter returnType) {
        Boolean flag;
        block3: {
            String cla;
            String[] stringArray;
            int n;
            int n2;
            flag = !returnType.hasMethodAnnotation(NoRestFulApi.class);
            if (!flag.booleanValue()) {
                return flag;
            }
            String cls = returnType.getContainingClass().getTypeName();
            if (ArrayUtil.isNotEmpty((Object[])this.restApiProperties.getIncludePackages()) && (n2 = 0) < (n = (stringArray = this.restApiProperties.getIncludePackages()).length)) {
                cla = stringArray[n2];
                flag = cls.contains(cla) ? Boolean.valueOf(true) : Boolean.valueOf(false);
            }
            if (ArrayUtil.isNotEmpty((Object[])this.restApiProperties.getExcludePackages()) && (n2 = 0) < (n = (stringArray = this.restApiProperties.getExcludePackages()).length)) {
                cla = stringArray[n2];
                flag = cls.contains(cla) ? Boolean.valueOf(false) : Boolean.valueOf(true);
            }
            Map controllerBeans = SpringUtil.getApplicationContext().getBeansWithAnnotation(RestController.class);
            controllerBeans.remove("openApiResource");
            controllerBeans.remove("swaggerConfigResource");
            Iterator iterator = controllerBeans.values().iterator();
            if (!iterator.hasNext()) break block3;
            Object bean = iterator.next();
            String packName = bean.getClass().getPackage().getName();
            flag = cls.contains(packName) ? Boolean.valueOf(true) : Boolean.valueOf(false);
        }
        return flag;
    }
}

