/*
 * Decompiled with CFR 0.152.
 */
package cn.soboys.restapispringbootstarter;

import cn.soboys.restapispringbootstarter.ResultCode;
import cn.soboys.restapispringbootstarter.exception.BusinessException;
import java.util.Map;
import java.util.function.Supplier;
import org.dromara.hutool.core.array.ArrayUtil;
import org.dromara.hutool.core.collection.CollUtil;
import org.dromara.hutool.core.map.MapUtil;
import org.dromara.hutool.core.text.StrUtil;
import org.dromara.hutool.core.util.ObjUtil;

public class Assert {
    private static final String TEMPLATE_VALUE_MUST_BE_BETWEEN_AND = "The value must be between {} and {}.";

    public static <X extends Throwable> void isTrue(boolean expression, Supplier<? extends X> supplier) throws X {
        if (!expression) {
            throw (Throwable)supplier.get();
        }
    }

    public static void isTrue(boolean expression, String errorMsgTemplate, Object ... params) throws BusinessException {
        Assert.isTrue(expression, () -> new BusinessException(StrUtil.format((CharSequence)errorMsgTemplate, (Object[])params)));
    }

    public static void isTrue(boolean expression, String message, String code) throws BusinessException {
        Assert.isTrue(expression, () -> new BusinessException(message, code));
    }

    public static void isTrue(boolean expression, ResultCode resultEnum) throws BusinessException {
        Assert.isTrue(expression, () -> new BusinessException(resultEnum));
    }

    public static void isTrue(boolean expression) throws BusinessException {
        Assert.isTrue(expression, "[Assertion failed] - this expression must be true", new Object[0]);
    }

    public static <X extends Throwable> void isFalse(boolean expression, Supplier<X> errorSupplier) throws X {
        if (expression) {
            throw (Throwable)errorSupplier.get();
        }
    }

    public static void isFalse(boolean expression, String errorMsgTemplate, Object ... params) throws BusinessException {
        Assert.isFalse(expression, () -> new BusinessException(StrUtil.format((CharSequence)errorMsgTemplate, (Object[])params)));
    }

    public static void isFalse(boolean expression, String message, String code) throws BusinessException {
        Assert.isFalse(expression, () -> new BusinessException(message, code));
    }

    public static void isFalse(boolean expression, ResultCode resultEnum) throws BusinessException {
        Assert.isFalse(expression, () -> new BusinessException(resultEnum));
    }

    public static void isFalse(boolean expression) throws BusinessException {
        Assert.isFalse(expression, "[Assertion failed] - this expression must be false", new Object[0]);
    }

    public static <X extends Throwable> void isNull(Object object, Supplier<X> errorSupplier) throws X {
        if (null != object) {
            throw (Throwable)errorSupplier.get();
        }
    }

    public static void isNull(Object object, String errorMsgTemplate, Object ... params) throws BusinessException {
        Assert.isNull(object, () -> new BusinessException(StrUtil.format((CharSequence)errorMsgTemplate, (Object[])params)));
    }

    public static void isNull(Object object, String message, String code) throws BusinessException {
        Assert.isNull(object, () -> new BusinessException(message, code));
    }

    public static void isNull(Object object, ResultCode resultEnum) throws BusinessException {
        Assert.isNull(object, () -> new BusinessException(resultEnum));
    }

    public static void isNull(Object object) throws BusinessException {
        Assert.isNull(object, "[Assertion failed] - the object argument must be null", new Object[0]);
    }

    public static <T, X extends Throwable> T notNull(T object, Supplier<X> errorSupplier) throws X {
        if (null == object) {
            throw (Throwable)errorSupplier.get();
        }
        return object;
    }

    public static <T> T notNull(T object, String errorMsgTemplate, Object ... params) throws BusinessException {
        return Assert.notNull(object, () -> new BusinessException(StrUtil.format((CharSequence)errorMsgTemplate, (Object[])params)));
    }

    public static <T> T notNull(T object, String message, String code) throws BusinessException {
        return Assert.notNull(object, () -> new BusinessException(message, code));
    }

    public static <T> T notNull(T object, ResultCode resultEnum) throws BusinessException {
        return Assert.notNull(object, () -> new BusinessException(resultEnum));
    }

    public static <T> T notNull(T object) throws BusinessException {
        return Assert.notNull(object, "[Assertion failed] - this argument is required; it must not be null", new Object[0]);
    }

    public static <T extends CharSequence, X extends Throwable> T notEmpty(T text, Supplier<X> errorSupplier) throws X {
        if (StrUtil.isEmpty(text)) {
            throw (Throwable)errorSupplier.get();
        }
        return text;
    }

    public static <T extends CharSequence> T notEmpty(T text, String errorMsgTemplate, Object ... params) throws BusinessException {
        return Assert.notEmpty(text, () -> new BusinessException(StrUtil.format((CharSequence)errorMsgTemplate, (Object[])params)));
    }

    public static <T extends CharSequence> T notEmpty(T text) throws BusinessException {
        return Assert.notEmpty(text, "[Assertion failed] - this String argument must have length; it must not be null or empty", new Object[0]);
    }

    public static <T extends CharSequence, X extends Throwable> T notBlank(T text, Supplier<X> errorMsgSupplier) throws X {
        if (StrUtil.isBlank(text)) {
            throw (Throwable)errorMsgSupplier.get();
        }
        return text;
    }

    public static <T extends CharSequence> T notBlank(T text, String errorMsgTemplate, Object ... params) throws BusinessException {
        return Assert.notBlank(text, () -> new BusinessException(StrUtil.format((CharSequence)errorMsgTemplate, (Object[])params)));
    }

    public static <T extends CharSequence> T notBlank(T text) throws BusinessException {
        return Assert.notBlank(text, "[Assertion failed] - this String argument must have text; it must not be null, empty, or blank", new Object[0]);
    }

    public static <T extends CharSequence, X extends Throwable> T notContain(CharSequence textToSearch, T substring, Supplier<X> errorSupplier) throws X {
        if (StrUtil.contains((CharSequence)textToSearch, substring)) {
            throw (Throwable)errorSupplier.get();
        }
        return substring;
    }

    public static String notContain(String textToSearch, String substring, String errorMsgTemplate, Object ... params) throws BusinessException {
        return Assert.notContain(textToSearch, substring, () -> new BusinessException(StrUtil.format((CharSequence)errorMsgTemplate, (Object[])params)));
    }

    public static String notContain(String textToSearch, String substring) throws BusinessException {
        return Assert.notContain(textToSearch, substring, "[Assertion failed] - this String argument must not contain the substring [{}]", substring);
    }

    public static <T, X extends Throwable> T[] notEmpty(T[] array, Supplier<X> errorSupplier) throws X {
        if (ArrayUtil.isEmpty((Object[])array)) {
            throw (Throwable)errorSupplier.get();
        }
        return array;
    }

    public static <T> T[] notEmpty(T[] array, String errorMsgTemplate, Object ... params) throws BusinessException {
        return Assert.notEmpty(array, () -> new BusinessException(StrUtil.format((CharSequence)errorMsgTemplate, (Object[])params)));
    }

    public static <T> T[] notEmpty(T[] array) throws BusinessException {
        return Assert.notEmpty(array, "[Assertion failed] - this array must not be empty: it must contain at least 1 element", new Object[0]);
    }

    public static <T, X extends Throwable> T[] noNullElements(T[] array, Supplier<X> errorSupplier) throws X {
        if (ArrayUtil.hasNull((Object[])array)) {
            throw (Throwable)errorSupplier.get();
        }
        return array;
    }

    public static <T> T[] noNullElements(T[] array, String errorMsgTemplate, Object ... params) throws BusinessException {
        return Assert.noNullElements(array, () -> new BusinessException(StrUtil.format((CharSequence)errorMsgTemplate, (Object[])params)));
    }

    public static <T> T[] noNullElements(T[] array) throws BusinessException {
        return Assert.noNullElements(array, "[Assertion failed] - this array must not contain any null elements", new Object[0]);
    }

    public static <E, T extends Iterable<E>, X extends Throwable> T notEmpty(T collection, Supplier<X> errorSupplier) throws X {
        if (CollUtil.isEmpty(collection)) {
            throw (Throwable)errorSupplier.get();
        }
        return collection;
    }

    public static <E, T extends Iterable<E>> T notEmpty(T collection, String errorMsgTemplate, Object ... params) throws BusinessException {
        return Assert.notEmpty(collection, () -> new BusinessException(StrUtil.format((CharSequence)errorMsgTemplate, (Object[])params)));
    }

    public static <E, T extends Iterable<E>> T notEmpty(T collection, String message, String code) throws BusinessException {
        return Assert.notEmpty(collection, () -> new BusinessException(message, code));
    }

    public static <E, T extends Iterable<E>> T notEmpty(T collection, ResultCode resultEnum) throws BusinessException {
        return Assert.notEmpty(collection, () -> new BusinessException(resultEnum));
    }

    public static <E, T extends Iterable<E>> T notEmpty(T collection) throws BusinessException {
        return Assert.notEmpty(collection, "[Assertion failed] - this collection must not be empty: it must contain at least 1 element", new Object[0]);
    }

    public static <K, V, T extends Map<K, V>, X extends Throwable> T notEmpty(T map, Supplier<X> errorSupplier) throws X {
        if (MapUtil.isEmpty(map)) {
            throw (Throwable)errorSupplier.get();
        }
        return map;
    }

    public static <K, V, T extends Map<K, V>> T notEmpty(T map, String errorMsgTemplate, Object ... params) throws BusinessException {
        return Assert.notEmpty(map, () -> new BusinessException(StrUtil.format((CharSequence)errorMsgTemplate, (Object[])params)));
    }

    public static <K, V, T extends Map<K, V>> T notEmpty(T map) throws BusinessException {
        return Assert.notEmpty(map, "[Assertion failed] - this map must not be empty; it must contain at least one entry", new Object[0]);
    }

    public static <T> T isInstanceOf(Class<?> type, T obj) {
        return Assert.isInstanceOf(type, obj, "Object [{}] is not instanceof [{}]", obj, type);
    }

    public static <T> T isInstanceOf(Class<?> type, T obj, String errorMsgTemplate, Object ... params) throws BusinessException {
        Assert.notNull(type, "Type to check against must not be null", new Object[0]);
        if (!type.isInstance(obj)) {
            throw new BusinessException(StrUtil.format((CharSequence)errorMsgTemplate, (Object[])params));
        }
        return obj;
    }

    public static void isAssignable(Class<?> superType, Class<?> subType) throws BusinessException {
        Assert.isAssignable(superType, subType, "{} is not assignable to {})", subType, superType);
    }

    public static void isAssignable(Class<?> superType, Class<?> subType, String errorMsgTemplate, Object ... params) throws BusinessException {
        Assert.notNull(superType, "Type to check against must not be null", new Object[0]);
        if (subType == null || !superType.isAssignableFrom(subType)) {
            throw new BusinessException(StrUtil.format((CharSequence)errorMsgTemplate, (Object[])params));
        }
    }

    public static void state(boolean expression, Supplier<String> errorMsgSupplier) throws IllegalStateException {
        if (!expression) {
            throw new IllegalStateException(errorMsgSupplier.get());
        }
    }

    public static void state(boolean expression, String errorMsgTemplate, Object ... params) throws IllegalStateException {
        if (!expression) {
            throw new IllegalStateException(StrUtil.format((CharSequence)errorMsgTemplate, (Object[])params));
        }
    }

    public static void state(boolean expression) throws IllegalStateException {
        Assert.state(expression, "[Assertion failed] - this state invariant must be true", new Object[0]);
    }

    public static int checkIndex(int index, int size) throws BusinessException, IndexOutOfBoundsException {
        return Assert.checkIndex(index, size, "[Assertion failed]", new Object[0]);
    }

    public static int checkIndex(int index, int size, String errorMsgTemplate, Object ... params) throws BusinessException, IndexOutOfBoundsException {
        if (index < 0 || index >= size) {
            throw new IndexOutOfBoundsException(Assert.badIndexMsg(index, size, errorMsgTemplate, params));
        }
        return index;
    }

    public static <X extends Throwable> int checkBetween(int value, int min, int max, Supplier<? extends X> errorSupplier) throws X {
        if (value < min || value > max) {
            throw (Throwable)errorSupplier.get();
        }
        return value;
    }

    public static int checkBetween(int value, int min, int max, String errorMsgTemplate, Object ... params) {
        return Assert.checkBetween(value, min, max, () -> new BusinessException(StrUtil.format((CharSequence)errorMsgTemplate, (Object[])params)));
    }

    public static int checkBetween(int value, int min, int max) {
        return Assert.checkBetween(value, min, max, TEMPLATE_VALUE_MUST_BE_BETWEEN_AND, new Object[]{min, max});
    }

    public static <X extends Throwable> long checkBetween(long value, long min, long max, Supplier<? extends X> errorSupplier) throws X {
        if (value < min || value > max) {
            throw (Throwable)errorSupplier.get();
        }
        return value;
    }

    public static long checkBetween(long value, long min, long max, String errorMsgTemplate, Object ... params) {
        return Assert.checkBetween(value, min, max, () -> new BusinessException(StrUtil.format((CharSequence)errorMsgTemplate, (Object[])params)));
    }

    public static long checkBetween(long value, long min, long max) {
        return Assert.checkBetween(value, min, max, TEMPLATE_VALUE_MUST_BE_BETWEEN_AND, new Object[]{min, max});
    }

    public static <X extends Throwable> double checkBetween(double value, double min, double max, Supplier<? extends X> errorSupplier) throws X {
        if (value < min || value > max) {
            throw (Throwable)errorSupplier.get();
        }
        return value;
    }

    public static double checkBetween(double value, double min, double max, String errorMsgTemplate, Object ... params) {
        return Assert.checkBetween(value, min, max, () -> new BusinessException(StrUtil.format((CharSequence)errorMsgTemplate, (Object[])params)));
    }

    public static double checkBetween(double value, double min, double max) {
        return Assert.checkBetween(value, min, max, TEMPLATE_VALUE_MUST_BE_BETWEEN_AND, min, max);
    }

    public static Number checkBetween(Number value, Number min, Number max) {
        Assert.notNull(value);
        Assert.notNull(min);
        Assert.notNull(max);
        double valueDouble = value.doubleValue();
        double minDouble = min.doubleValue();
        double maxDouble = max.doubleValue();
        if (valueDouble < minDouble || valueDouble > maxDouble) {
            throw new BusinessException(StrUtil.format((CharSequence)TEMPLATE_VALUE_MUST_BE_BETWEEN_AND, (Object[])new Object[]{min, max}));
        }
        return value;
    }

    public static void notEquals(Object obj1, Object obj2) {
        Assert.notEquals(obj1, obj2, "({}) must be not equals ({})", obj1, obj2);
    }

    public static void notEquals(Object obj1, Object obj2, String errorMsgTemplate, Object ... params) throws BusinessException {
        Assert.notEquals(obj1, obj2, () -> new BusinessException(StrUtil.format((CharSequence)errorMsgTemplate, (Object[])params)));
    }

    public static <X extends Throwable> void notEquals(Object obj1, Object obj2, Supplier<X> errorSupplier) throws X {
        if (ObjUtil.equals((Object)obj1, (Object)obj2)) {
            throw (Throwable)errorSupplier.get();
        }
    }

    public static void equals(Object obj1, Object obj2) {
        Assert.equals(obj1, obj2, "({}) must be equals ({})", obj1, obj2);
    }

    public static void equals(Object obj1, Object obj2, String errorMsgTemplate, Object ... params) throws BusinessException {
        Assert.equals(obj1, obj2, () -> new BusinessException(StrUtil.format((CharSequence)errorMsgTemplate, (Object[])params)));
    }

    public static <X extends Throwable> void equals(Object obj1, Object obj2, Supplier<X> errorSupplier) throws X {
        if (ObjUtil.notEquals((Object)obj1, (Object)obj2)) {
            throw (Throwable)errorSupplier.get();
        }
    }

    private static String badIndexMsg(int index, int size, String desc, Object ... params) {
        if (index < 0) {
            return StrUtil.format((CharSequence)"{} ({}) must not be negative", (Object[])new Object[]{StrUtil.format((CharSequence)desc, (Object[])params), index});
        }
        if (size < 0) {
            throw new BusinessException("negative size: " + size);
        }
        return StrUtil.format((CharSequence)"{} ({}) must be less than size ({})", (Object[])new Object[]{StrUtil.format((CharSequence)desc, (Object[])params), index, size});
    }
}

