/*
 * Decompiled with CFR 0.152.
 */
package cn.soboys.restapispringbootstarter.interceptor;

import cn.soboys.restapispringbootstarter.authorization.LoginAuthorization;
import cn.soboys.restapispringbootstarter.authorization.UrlMatcher;
import cn.soboys.restapispringbootstarter.authorization.UserJwtToken;
import cn.soboys.restapispringbootstarter.config.RestApiProperties;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.dromara.hutool.core.text.StrUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.BeanCreationException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.web.servlet.ModelAndView;

public class JwtTokenInterceptor
implements HandlerInterceptor {
    private static final Logger log = LoggerFactory.getLogger(JwtTokenInterceptor.class);
    @Autowired
    private UserJwtToken userJwtToken;
    @Autowired
    private LoginAuthorization loginAuthorization;

    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) throws Exception {
        RestApiProperties.JwtProperties jwtProperties = this.userJwtToken.getJwtProperties();
        if (jwtProperties != null && jwtProperties.getAuthorization().getHasAuthorization().booleanValue() && StrUtil.isNotEmpty((CharSequence)jwtProperties.getAuthorization().getIncludesUrl())) {
            if (this.loginAuthorization == null) {
                throw new BeanCreationException("Unable to inject the LoginAuthorization  bean");
            }
            UrlMatcher matcher = new UrlMatcher(jwtProperties.getAuthorization().getIncludesUrl(), jwtProperties.getAuthorization().getExcludesUrl());
            if (matcher.matches(request.getRequestURI())) {
                this.loginAuthorization.authorization(request, response, handler);
            }
        }
        return true;
    }

    public void postHandle(HttpServletRequest request, HttpServletResponse response, Object handler, ModelAndView modelAndView) throws Exception {
    }

    public void afterCompletion(HttpServletRequest request, HttpServletResponse response, Object handler, Exception ex) throws Exception {
    }
}

