/*
 * Decompiled with CFR 0.152.
 */
package cn.soboys.restapispringbootstarter.authorization;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class UrlMatcher {
    private static final String TMP_PLACEHOLDER = "@@@@@#####$$$$$";
    private List<Pattern> includePatterns;
    private List<Pattern> excludePatterns;

    public UrlMatcher(String includes, String excludes) {
        this.includePatterns = this.valueToPatterns(includes);
        this.excludePatterns = this.valueToPatterns(excludes);
    }

    private List<Pattern> valueToPatterns(String value) {
        String[] patternItems;
        ArrayList<Pattern> patterns = new ArrayList<Pattern>();
        if (value == null) {
            return patterns;
        }
        for (String patternItem : patternItems = value.split(",")) {
            if ("".equals(patternItem = patternItem.trim())) continue;
            patternItem = patternItem.replace("**", TMP_PLACEHOLDER);
            patternItem = patternItem.replace("*", "[^/]*?");
            patternItem = patternItem.replace(TMP_PLACEHOLDER, "**");
            patternItem = patternItem.replace("**", ".*?");
            patterns.add(Pattern.compile(patternItem));
        }
        return patterns;
    }

    public boolean matches(String url) {
        return this.matches(this.includePatterns, url) && !this.matches(this.excludePatterns, url);
    }

    private boolean matches(List<Pattern> patterns, String url) {
        for (Pattern pattern : patterns) {
            Matcher matcher = pattern.matcher(url);
            if (!matcher.matches()) continue;
            return true;
        }
        return false;
    }

    public static void main(String[] args) {
        UrlMatcher matcher = new UrlMatcher("/**", "");
        System.out.println(matcher.matches("/v3/api-docs"));
    }
}

