/*
 * Decompiled with CFR 0.152.
 */
package cn.soboys.restapispringbootstarter;

import cn.soboys.restapispringbootstarter.HttpStatus;
import cn.soboys.restapispringbootstarter.Result;
import cn.soboys.restapispringbootstarter.exception.BusinessException;
import cn.soboys.restapispringbootstarter.exception.CacheException;
import cn.soboys.restapispringbootstarter.exception.LimitAccessException;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.validation.ConstraintViolation;
import javax.validation.ConstraintViolationException;
import javax.validation.Path;
import org.dromara.hutool.core.collection.CollUtil;
import org.dromara.hutool.core.exception.ExceptionUtil;
import org.dromara.hutool.core.text.StrUtil;
import org.hibernate.validator.internal.engine.path.PathImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.http.converter.HttpMessageNotReadableException;
import org.springframework.validation.BindException;
import org.springframework.validation.BindingResult;
import org.springframework.validation.FieldError;
import org.springframework.web.HttpMediaTypeNotSupportedException;
import org.springframework.web.HttpRequestMethodNotSupportedException;
import org.springframework.web.bind.MethodArgumentNotValidException;
import org.springframework.web.bind.annotation.RestControllerAdvice;
import org.springframework.web.servlet.NoHandlerFoundException;

@RestControllerAdvice
@ConditionalOnWebApplication(type=ConditionalOnWebApplication.Type.SERVLET)
public class ExceptionHandler {
    private static final Logger log = LoggerFactory.getLogger(ExceptionHandler.class);

    @org.springframework.web.bind.annotation.ExceptionHandler(value={Exception.class})
    public Result error(Exception e) {
        log.error("\u672a\u77e5\u5f02\u5e38{}", (Object)ExceptionUtil.stacktraceToString((Throwable)e));
        return Result.buildFailure(HttpStatus.INTERNAL_SERVER_ERROR, ExceptionUtil.stacktraceToString((Throwable)e));
    }

    @org.springframework.web.bind.annotation.ExceptionHandler(value={BusinessException.class})
    public Result error(BusinessException e) {
        return Result.buildFailure(e.getCode(), e.getMessage());
    }

    @org.springframework.web.bind.annotation.ExceptionHandler(value={BindException.class})
    public Result BindExceptionHandler(BindException e, HttpServletRequest request) {
        List fieldErrors = e.getBindingResult().getFieldErrors();
        List collect = fieldErrors.stream().map(o -> o.getField() + o.getDefaultMessage()).collect(Collectors.toList());
        request.setAttribute("argument_error", (Object)CollUtil.join(collect, (CharSequence)";"));
        return Result.buildFailure(HttpStatus.INVALID_ARGUMENT.getCode(), StrUtil.format((CharSequence)HttpStatus.INVALID_ARGUMENT.getMessage(), (Object[])new Object[]{CollUtil.join(collect, (CharSequence)";")}));
    }

    @org.springframework.web.bind.annotation.ExceptionHandler(value={ConstraintViolationException.class})
    public Result ConstraintViolationExceptionHandler(ConstraintViolationException e, HttpServletRequest request) {
        ArrayList<String> errorList = new ArrayList<String>();
        Set violations = e.getConstraintViolations();
        for (ConstraintViolation violation : violations) {
            StringBuilder message = new StringBuilder();
            Path path = violation.getPropertyPath();
            String msg = message.append(((PathImpl)path).getLeafNode()).append(violation.getMessage()).toString();
            errorList.add(msg);
        }
        request.setAttribute("argument_error", (Object)CollUtil.join(errorList, (CharSequence)";"));
        return Result.buildFailure(HttpStatus.INVALID_ARGUMENT.getCode(), StrUtil.format((CharSequence)HttpStatus.INVALID_ARGUMENT.getMessage(), (Object[])new Object[]{CollUtil.join(errorList, (CharSequence)";")}));
    }

    @org.springframework.web.bind.annotation.ExceptionHandler(value={MethodArgumentNotValidException.class})
    public Result jsonParamsException(MethodArgumentNotValidException e, HttpServletRequest request) {
        BindingResult bindingResult = e.getBindingResult();
        ArrayList<String> errorList = new ArrayList<String>();
        for (FieldError fieldError : bindingResult.getFieldErrors()) {
            String msg = String.format("%s%s\uff1b", fieldError.getField(), fieldError.getDefaultMessage());
            errorList.add(msg);
        }
        request.setAttribute("argument_error", (Object)CollUtil.join(errorList, (CharSequence)";"));
        return Result.buildFailure(HttpStatus.INVALID_ARGUMENT.getCode(), StrUtil.format((CharSequence)HttpStatus.INVALID_ARGUMENT.getMessage(), (Object[])new Object[]{CollUtil.join(errorList, (CharSequence)";")}));
    }

    @org.springframework.web.bind.annotation.ExceptionHandler(value={NoHandlerFoundException.class})
    public Result error(NoHandlerFoundException e) {
        return Result.buildFailure(HttpStatus.NOT_FOUND, e.getRequestURL());
    }

    @org.springframework.web.bind.annotation.ExceptionHandler(value={HttpRequestMethodNotSupportedException.class})
    public Result httpRequestMethodNotSupportedException(HttpRequestMethodNotSupportedException e) {
        return Result.buildFailure(HttpStatus.METHOD_NOT_ALLOWED, ExceptionUtil.stacktraceToString((Throwable)e));
    }

    @org.springframework.web.bind.annotation.ExceptionHandler(value={HttpMediaTypeNotSupportedException.class})
    public Result httpMediaTypeNotSupportedException(HttpMediaTypeNotSupportedException e) {
        return Result.buildFailure(HttpStatus.BAD_GATEWAY, ExceptionUtil.stacktraceToString((Throwable)e));
    }

    @org.springframework.web.bind.annotation.ExceptionHandler(value={HttpMessageNotReadableException.class})
    public Result HttpMessageNotReadableException(HttpMessageNotReadableException e, HttpServletRequest request) {
        request.setAttribute("argument_error", (Object)e.getMessage());
        return Result.buildFailure(HttpStatus.INVALID_ARGUMENT.getCode(), StrUtil.format((CharSequence)HttpStatus.INVALID_ARGUMENT.getMessage(), (Object[])new Object[]{e.getMessage()}), ExceptionUtil.stacktraceToString((Throwable)e));
    }

    @org.springframework.web.bind.annotation.ExceptionHandler(value={LimitAccessException.class})
    public Result LimitAccessExceptionException(LimitAccessException e, HttpServletRequest request) {
        request.setAttribute("argument_error", (Object)e.getMessage());
        return Result.buildFailure(HttpStatus.REQUEST_TIMEOUT.getCode(), StrUtil.format((CharSequence)HttpStatus.REQUEST_TIMEOUT.getMessage(), (Object[])new Object[]{e.getMessage()}), ExceptionUtil.stacktraceToString((Throwable)e));
    }

    @org.springframework.web.bind.annotation.ExceptionHandler(value={CacheException.class})
    public Result CacheException(CacheException e, HttpServletRequest request) {
        request.setAttribute("argument_error", (Object)e.getMessage());
        return Result.buildFailure(HttpStatus.CACHE_EXCEPTION.getCode(), StrUtil.format((CharSequence)HttpStatus.CACHE_EXCEPTION.getMessage(), (Object[])new Object[]{e.getMessage()}), ExceptionUtil.stacktraceToString((Throwable)e));
    }
}

