/*
 * Decompiled with CFR 0.152.
 */
package cn.soboys.restapispringbootstarter.test;

import cn.soboys.restapispringbootstarter.Result;
import cn.soboys.restapispringbootstarter.authorization.UserJwtToken;
import cn.soboys.restapispringbootstarter.test.UserEntry;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Validated
@Tag(name="\u7528\u6237\u63a5\u53e3")
public class TestController {
    private static final Logger log = LoggerFactory.getLogger(TestController.class);
    @Autowired
    private UserJwtToken userJwtToken;

    @PostMapping(value={"/test"})
    @Operation(summary="\u5206\u9875\u67e5\u8be2")
    public Map chatDialogue() {
        HashMap<String, Object> m = new HashMap<String, Object>();
        m.put("name", "judy");
        m.put("age", 26);
        return m;
    }

    @GetMapping(value={"/loginMap"})
    public Result loginMap() {
        UserEntry userEntry = new UserEntry();
        userEntry.setUserId("1");
        userEntry.setUsername("judy");
        userEntry.setHobby("swing");
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("userId", userEntry.getUserId());
        map.put("name", userEntry.getUsername());
        map.put("user", userEntry);
        String token = this.userJwtToken.createdToken(userEntry.getUserId(), userEntry.getUsername(), map);
        return Result.buildSuccess(token);
    }

    @GetMapping(value={"/login"})
    public Result login() {
        UserEntry userEntry = new UserEntry();
        userEntry.setUserId("2");
        userEntry.setUsername("billy");
        userEntry.setHobby("eat");
        this.userJwtToken.rememberMe = true;
        String token = this.userJwtToken.createdToken(userEntry.getUserId(), userEntry.getUsername(), userEntry);
        return Result.buildSuccess(token);
    }

    @GetMapping(value={"/user"})
    public Result getUser() {
        String token = "eyJhbGciOiJIUzI1NiIsInppcCI6IkRFRiJ9.eNqqViouTVKyUkrKzMmpVNJRyiwuBvKMgKyskkwoK7WiQMnK0MzC0tTUwsDEWEeptDi1SMmqGkx7pkBVgTh5ibmpSIZl5CclVQL5qYklSrW1AAAAAP__.8nWRs40LbRTIQBhJ8jVaANPcvsmX0zoLR66R-b2Uc4M";
        String userId = this.userJwtToken.getUserId(token);
        return Result.buildSuccess(userId);
    }

    @GetMapping(value={"/register/test"})
    public Result register() {
        return Result.buildSuccess("register");
    }
}

