/*
 * Decompiled with CFR 0.152.
 */
package cn.soboys.restapispringbootstarter.config;

import cn.soboys.restapispringbootstarter.ApplicationRunner;
import cn.soboys.restapispringbootstarter.ExceptionHandler;
import cn.soboys.restapispringbootstarter.ResultHandler;
import cn.soboys.restapispringbootstarter.aop.LimitAspect;
import cn.soboys.restapispringbootstarter.aop.LogAspect;
import cn.soboys.restapispringbootstarter.config.RestApiProperties;
import cn.soboys.restapispringbootstarter.config.StartupApplicationListener;
import cn.soboys.restapispringbootstarter.i18n.I18NMessage;
import cn.soboys.restapispringbootstarter.utils.RestFulTemp;
import java.nio.charset.Charset;
import java.util.List;
import javax.validation.Validation;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;
import org.dromara.hutool.extra.spring.EnableSpringUtil;
import org.hibernate.validator.HibernateValidator;
import org.hibernate.validator.HibernateValidatorConfiguration;
import org.springframework.context.annotation.Bean;
import org.springframework.http.client.ClientHttpRequestFactory;
import org.springframework.http.client.SimpleClientHttpRequestFactory;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.http.converter.StringHttpMessageConverter;
import org.springframework.http.converter.json.MappingJackson2HttpMessageConverter;
import org.springframework.http.converter.support.AllEncompassingFormHttpMessageConverter;
import org.springframework.web.client.RestTemplate;

@EnableSpringUtil
public class BeanAutoConfiguration {
    @Bean
    public I18NMessage i18NMessage() {
        return new I18NMessage();
    }

    @Bean
    public ResultHandler resultHandler() {
        return new ResultHandler();
    }

    @Bean
    public ExceptionHandler exceptionHandler() {
        return new ExceptionHandler();
    }

    @Bean
    public StartupApplicationListener startupApplicationListener() {
        return new StartupApplicationListener();
    }

    @Bean
    public RestApiProperties restApiProperties() {
        return new RestApiProperties();
    }

    @Bean
    public RestApiProperties.LoggingProperties loggingProperties(RestApiProperties restApiProperties) {
        return new RestApiProperties.LoggingProperties(restApiProperties);
    }

    @Bean
    public RestApiProperties.Ip2regionProperties ip2regionProperties(RestApiProperties restApiProperties) {
        return new RestApiProperties.Ip2regionProperties(restApiProperties);
    }

    @Bean
    public RestApiProperties.JwtProperties jwtProperties(RestApiProperties restApiProperties) {
        return new RestApiProperties.JwtProperties(restApiProperties);
    }

    @Bean
    public ApplicationRunner applicationRunner() {
        return new ApplicationRunner();
    }

    @Bean
    public LogAspect logAspect() {
        return new LogAspect();
    }

    @Bean
    public LimitAspect limitAspect() {
        return new LimitAspect();
    }

    @Bean
    public Validator validator() {
        ValidatorFactory validatorFactory = ((HibernateValidatorConfiguration)((HibernateValidatorConfiguration)Validation.byProvider(HibernateValidator.class).configure()).failFast(true)).buildValidatorFactory();
        return validatorFactory.getValidator();
    }

    public class RestTemplateConfig {
        private final Charset thirdRequest = Charset.forName("utf-8");

        @Bean
        public RestTemplate restTemplate(ClientHttpRequestFactory factory) {
            RestTemplate restTemplate = new RestTemplate(factory);
            List messageConverters = restTemplate.getMessageConverters();
            for (HttpMessageConverter messageConverter : messageConverters) {
                if (messageConverter instanceof StringHttpMessageConverter) {
                    ((StringHttpMessageConverter)messageConverter).setDefaultCharset(this.thirdRequest);
                }
                if (messageConverter instanceof MappingJackson2HttpMessageConverter) {
                    ((MappingJackson2HttpMessageConverter)messageConverter).setDefaultCharset(this.thirdRequest);
                }
                if (!(messageConverter instanceof AllEncompassingFormHttpMessageConverter)) continue;
                ((AllEncompassingFormHttpMessageConverter)messageConverter).setCharset(this.thirdRequest);
            }
            return restTemplate;
        }

        @Bean
        public ClientHttpRequestFactory simpleClientHttpRequestFactory() {
            SimpleClientHttpRequestFactory factory = new SimpleClientHttpRequestFactory();
            factory.setConnectTimeout(15000);
            factory.setReadTimeout(5000);
            return factory;
        }

        @Bean
        public RestFulTemp restFulTemp() {
            return new RestFulTemp();
        }
    }
}

