/*
 * Decompiled with CFR 0.152.
 */
package cn.soboys.restapispringbootstarter.cache;

import cn.soboys.restapispringbootstarter.cache.SpringCacheUtil;
import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.PropertyAccessor;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.jsontype.PolymorphicTypeValidator;
import com.fasterxml.jackson.databind.jsontype.impl.LaissezFaireSubTypeValidator;
import java.lang.reflect.Method;
import java.util.Arrays;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.cache.CacheManager;
import org.springframework.cache.annotation.EnableCaching;
import org.springframework.cache.interceptor.KeyGenerator;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.data.redis.cache.RedisCacheConfiguration;
import org.springframework.data.redis.cache.RedisCacheManager;
import org.springframework.data.redis.connection.RedisConnectionFactory;
import org.springframework.data.redis.serializer.GenericJackson2JsonRedisSerializer;
import org.springframework.data.redis.serializer.RedisSerializationContext;
import org.springframework.data.redis.serializer.RedisSerializer;
import org.springframework.data.redis.serializer.StringRedisSerializer;

@Configuration
@EnableCaching
@ConditionalOnClass(name={"org.springframework.data.redis.core.RedisOperations"})
public class SpringCacheConfig {
    @Autowired
    private RedisConnectionFactory redisConnectionFactory;

    @Bean(value={"keyGeneratorStrategy"})
    public KeyGenerator keyGeneratorStrategy() {
        return new KeyGenerator(){

            public Object generate(Object target, Method method, Object ... params) {
                return method.getName() + "[" + Arrays.asList(params).toString() + "]";
            }
        };
    }

    @Bean
    public SpringCacheUtil springCacheUtil() {
        return new SpringCacheUtil();
    }

    @Bean
    public CacheManager cacheManager() {
        RedisCacheConfiguration config = RedisCacheConfiguration.defaultCacheConfig().serializeKeysWith(RedisSerializationContext.SerializationPair.fromSerializer(this.keySerializer())).serializeValuesWith(RedisSerializationContext.SerializationPair.fromSerializer(this.valueSerializer())).disableCachingNullValues();
        RedisCacheManager redisCacheManager = RedisCacheManager.builder((RedisConnectionFactory)this.redisConnectionFactory).cacheDefaults(config).transactionAware().build();
        return redisCacheManager;
    }

    private RedisSerializer<String> keySerializer() {
        return new StringRedisSerializer();
    }

    private RedisSerializer<Object> valueSerializer() {
        ObjectMapper om = new ObjectMapper();
        om.setVisibility(PropertyAccessor.ALL, JsonAutoDetect.Visibility.ANY);
        om.activateDefaultTyping((PolymorphicTypeValidator)LaissezFaireSubTypeValidator.instance, ObjectMapper.DefaultTyping.NON_FINAL);
        return new GenericJackson2JsonRedisSerializer(om);
    }
}

