/*
 * Decompiled with CFR 0.152.
 */
package cn.soboys.restapispringbootstarter.cache;

import cn.soboys.restapispringbootstarter.cache.RedisTempUtil;
import cn.soboys.restapispringbootstarter.exception.CacheException;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.StringUtils;

public interface CacheTmp {
    public String getKey();

    public Boolean getHasPrefix();

    default public String key(String ... keyParts) {
        return CacheTmp.key(this.getKey(), this.getHasPrefix(), keyParts);
    }

    default public boolean valid(String ... keyParts) {
        return RedisTempUtil.getInstance().hasKey(this.key(keyParts));
    }

    public static String key(String key, boolean hasPrefix, String[] keyParts) {
        if (keyParts == null) {
            throw new CacheException("keyParts\u4e0d\u80fd\u4e3anull");
        }
        if (hasPrefix && keyParts.length == 0) {
            throw new CacheException("\u6709\u524d\u7f00\uff0c\u9700\u8981\u4f20keyParts");
        }
        if (!hasPrefix && keyParts.length > 0) {
            throw new CacheException("\u65e0\u524d\u7f00\uff0c\u4e0d\u9700\u8981\u4f20keyParts");
        }
        if (keyParts.length == 0) {
            return key;
        }
        return key + (key.endsWith(":") ? "" : ":") + StringUtils.join((Object[])keyParts, (String)":");
    }

    default public void valueSet(Object value, String ... keyParts) {
        RedisTempUtil.getInstance().set(this.key(keyParts), value);
    }

    default public void valueSetAndExpire(Object value, long timeout, TimeUnit unit, String ... keyParts) {
        RedisTempUtil.getInstance().set(this.key(keyParts), value, timeout, unit);
    }

    default public <T> T valueGet(String ... keyParts) {
        return (T)RedisTempUtil.getInstance().get(this.key(keyParts));
    }

    default public Boolean delete(String ... keyParts) {
        return RedisTempUtil.getInstance().delete(this.key(keyParts));
    }
}

