/*
 * Decompiled with CFR 0.152.
 */
package cn.soboys.restapispringbootstarter.utils;

import cn.soboys.restapispringbootstarter.config.RestApiProperties;
import cn.soboys.restapispringbootstarter.utils.RequestUtil;
import java.io.File;
import java.io.InputStream;
import javax.servlet.http.HttpServletRequest;
import org.dromara.hutool.core.exception.ExceptionUtil;
import org.dromara.hutool.core.io.file.FileUtil;
import org.dromara.hutool.extra.spring.SpringUtil;
import org.dromara.hutool.http.useragent.UserAgent;
import org.dromara.hutool.http.useragent.UserAgentUtil;
import org.lionsoul.ip2region.xdb.Searcher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.DefaultResourceLoader;
import org.springframework.core.io.Resource;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

public class HttpUserAgent {
    private static final Logger log = LoggerFactory.getLogger(HttpUserAgent.class);
    private static final String UNKNOWN = "unknown";
    private static RestApiProperties.Ip2regionProperties ip2regionProperties = (RestApiProperties.Ip2regionProperties)SpringUtil.getBean(RestApiProperties.Ip2regionProperties.class);

    public static HttpServletRequest getRequest() {
        return ((ServletRequestAttributes)RequestContextHolder.getRequestAttributes()).getRequest();
    }

    public static String getDevice() {
        HttpServletRequest request = HttpUserAgent.getRequest();
        String uaStr = request.getHeader("User-Agent");
        UserAgent ua = UserAgentUtil.parse((String)uaStr);
        return uaStr;
    }

    public static String getDeviceBrowser() {
        HttpServletRequest request = HttpUserAgent.getRequest();
        String uaStr = request.getHeader("User-Agent");
        UserAgent ua = UserAgentUtil.parse((String)uaStr);
        String browser = ua.getBrowser().toString();
        return browser;
    }

    public static String getDeviceSystem() {
        HttpServletRequest request = HttpUserAgent.getRequest();
        String uaStr = request.getHeader("User-Agent");
        UserAgent ua = UserAgentUtil.parse((String)uaStr);
        String platform = ua.getPlatform().toString();
        return platform;
    }

    public static String getIpAddr() {
        String ip = null;
        HttpServletRequest request = RequestUtil.getReq();
        String ipAddresses = request.getHeader("X-Real-IP");
        if (ipAddresses == null || ipAddresses.length() == 0 || UNKNOWN.equalsIgnoreCase(ipAddresses)) {
            ipAddresses = request.getHeader("X-Forwarded-For");
        }
        if (ipAddresses == null || ipAddresses.length() == 0 || UNKNOWN.equalsIgnoreCase(ipAddresses)) {
            ipAddresses = request.getHeader("Proxy-Client-IP");
        }
        if (ipAddresses == null || ipAddresses.length() == 0 || UNKNOWN.equalsIgnoreCase(ipAddresses)) {
            ipAddresses = request.getHeader("WL-Proxy-Client-IP");
        }
        if (ipAddresses == null || ipAddresses.length() == 0 || UNKNOWN.equalsIgnoreCase(ipAddresses)) {
            ipAddresses = request.getHeader("HTTP_CLIENT_IP");
        }
        if (ipAddresses != null && ipAddresses.length() != 0) {
            ip = ipAddresses.split(",")[0];
        }
        if (ip == null || ip.length() == 0 || UNKNOWN.equalsIgnoreCase(ipAddresses)) {
            ip = request.getRemoteAddr();
        }
        return "0:0:0:0:0:0:0:1".equals(ip) ? "127.0.0.1" : ip;
    }

    public static String getIpToCityInfo(String ip) {
        try {
            File file;
            DefaultResourceLoader resourceLoader = new DefaultResourceLoader();
            Resource resource = resourceLoader.getResource(ip2regionProperties.getLocation());
            String dbPath = "";
            if (resource.getURI().getScheme().equals("jar")) {
                file = new File("src/main/resources/" + ((ClassPathResource)resource).getPath());
                FileUtil.writeFromStream((InputStream)resource.getInputStream(), (File)file);
                dbPath = file.getAbsolutePath();
            } else {
                dbPath = resource.getFile().getPath();
            }
            file = new File(dbPath);
            if (!file.exists()) {
                log.error("ip2region.xdb\u6587\u4ef6\u627e\u4e0d\u5230\u8bf7\u586b\u5199\u7c7b\u8def\u5f84");
                return "UNKNOWN";
            }
            Searcher searcher = Searcher.newWithFileOnly((String)dbPath);
            return searcher.search(ip);
        }
        catch (Exception e) {
            log.error("Ip\u67e5\u8be2\u57ce\u5e02\u5730\u5740\u89e3\u6790\u5931\u8d25{}", (Object)ExceptionUtil.stacktraceToString((Throwable)e));
            e.printStackTrace();
            return "UNKNOWN";
        }
    }
}

