/*
 * Decompiled with CFR 0.152.
 */
package cn.soboys.restapispringbootstarter.aop;

import cn.soboys.restapispringbootstarter.Result;
import cn.soboys.restapispringbootstarter.aop.BaseAspectSupport;
import cn.soboys.restapispringbootstarter.config.RestApiProperties;
import cn.soboys.restapispringbootstarter.enums.LogTypeEnum;
import cn.soboys.restapispringbootstarter.log.Log;
import cn.soboys.restapispringbootstarter.log.LogDataSource;
import cn.soboys.restapispringbootstarter.log.LogEntry;
import cn.soboys.restapispringbootstarter.log.LogFileDefaultDataSource;
import cn.soboys.restapispringbootstarter.utils.HttpUserAgent;
import cn.soboys.restapispringbootstarter.utils.RequestUtil;
import java.lang.reflect.Method;
import javax.servlet.http.HttpServletRequest;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.AfterThrowing;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.aspectj.lang.reflect.MethodSignature;
import org.dromara.hutool.core.exception.ExceptionUtil;
import org.dromara.hutool.core.text.StrUtil;
import org.dromara.hutool.json.JSON;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

@Component
@Aspect
public class LogAspect
extends BaseAspectSupport {
    private static final Logger log = LoggerFactory.getLogger(LogAspect.class);
    @Autowired
    private RestApiProperties.LoggingProperties loggingProperties;
    private long currentTime = 0L;

    @Pointcut(value="@annotation(cn.soboys.restapispringbootstarter.log.Log)")
    public void logPointcut() {
    }

    @Around(value="logPointcut()")
    public Object logAround(ProceedingJoinPoint joinPoint) throws Throwable {
        this.currentTime = System.currentTimeMillis();
        Object result = joinPoint.proceed();
        LogEntry logBean = this.analyResult(result);
        ServletRequestAttributes attributes = (ServletRequestAttributes)RequestContextHolder.getRequestAttributes();
        HttpServletRequest request = attributes.getRequest();
        if (result != null) {
            logBean.setPath(request.getRequestURI());
        }
        this.saveLog((JoinPoint)joinPoint, logBean);
        return result;
    }

    @AfterThrowing(pointcut="logPointcut()", throwing="e")
    public void logAfterThrowing(JoinPoint joinPoint, Throwable e) {
        LogEntry logBean = new LogEntry(LogTypeEnum.ERROR.name(), System.currentTimeMillis() - this.currentTime);
        logBean.setExceptionDetail(ExceptionUtil.stacktraceToString((Throwable)e));
    }

    private LogEntry analyResult(Object result) {
        LogEntry logBean = new LogEntry(LogTypeEnum.INFO.name(), System.currentTimeMillis() - this.currentTime);
        if (result instanceof Result) {
            Result res = (Result)result;
            if (!res.getSuccess().booleanValue() || res.getCode() != "OK") {
                logBean.setLogType(LogTypeEnum.ERROR.name());
                logBean.setExceptionDetail(res.getMsg());
                logBean.setRequestId(res.getRequestId());
            } else {
                logBean.setResult(res);
            }
        }
        return logBean;
    }

    private void saveLog(JoinPoint joinPoint, LogEntry logBean) {
        try {
            MethodSignature signature = (MethodSignature)joinPoint.getSignature();
            Method method = signature.getMethod();
            Log logAnnotation = method.getAnnotation(Log.class);
            String methodName = signature.getName();
            logBean.setDescription(logAnnotation.value());
            logBean.setApiType(logAnnotation.apiType().name());
            logBean.setMethod(joinPoint.getTarget().getClass().getName() + "." + methodName + "()");
            HttpServletRequest req = HttpUserAgent.getRequest();
            String ip = HttpUserAgent.getIpAddr();
            logBean.setRequestIp(ip);
            if (logAnnotation.ipCity()) {
                logBean.setAddress(HttpUserAgent.getIpToCityInfo(ip));
            }
            logBean.setOs(HttpUserAgent.getDeviceSystem());
            logBean.setBrowser(HttpUserAgent.getDeviceBrowser());
            logBean.setDevice(HttpUserAgent.getDevice());
            JSON params = RequestUtil.getRequestParams(req);
            logBean.setParams(params == null ? null : params);
            if (this.loggingProperties != null && StrUtil.isNotEmpty((CharSequence)this.loggingProperties.getLogDataSourceClass())) {
                Class<?> clazz = Class.forName(this.loggingProperties.getLogDataSourceClass());
                Object instance = clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                ((LogDataSource)instance).save(logBean);
            } else {
                LogFileDefaultDataSource fileDefaultDataSource = new LogFileDefaultDataSource();
                fileDefaultDataSource.save(logBean);
            }
        }
        catch (Exception e) {
            log.error("\u65e5\u5fd7AOP\u5c01\u88c5log\u5bf9\u8c61\u5f02\u5e38:", (Object)ExceptionUtil.stacktraceToString((Throwable)e));
        }
    }
}

