/*
 * Decompiled with CFR 0.152.
 */
package cn.soboys.restapispringbootstarter.utils;

import javax.servlet.http.HttpServletRequest;
import org.dromara.hutool.http.useragent.UserAgent;
import org.dromara.hutool.http.useragent.UserAgentUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

public class HttpUserAgent {
    private static final Logger log = LoggerFactory.getLogger(HttpUserAgent.class);
    private static final String UNKNOWN = "unknown";

    public static HttpServletRequest getRequest() {
        return ((ServletRequestAttributes)RequestContextHolder.getRequestAttributes()).getRequest();
    }

    public static String getDevice() {
        HttpServletRequest request = HttpUserAgent.getRequest();
        String uaStr = request.getHeader("User-Agent");
        UserAgent ua = UserAgentUtil.parse((String)uaStr);
        return uaStr;
    }

    public static String getDeviceBrowser() {
        HttpServletRequest request = HttpUserAgent.getRequest();
        String uaStr = request.getHeader("User-Agent");
        UserAgent ua = UserAgentUtil.parse((String)uaStr);
        String browser = ua.getBrowser().toString();
        return browser;
    }

    public static String getDeviceSystem() {
        HttpServletRequest request = HttpUserAgent.getRequest();
        String uaStr = request.getHeader("User-Agent");
        UserAgent ua = UserAgentUtil.parse((String)uaStr);
        String platform = ua.getPlatform().toString();
        return platform;
    }

    public static String getIpAddr() {
        HttpServletRequest request = HttpUserAgent.getRequest();
        String ip = request.getHeader("x-forwarded-for");
        if (ip == null || ip.length() == 0 || UNKNOWN.equalsIgnoreCase(ip)) {
            ip = request.getHeader("Proxy-Client-IP");
        }
        if (ip == null || ip.length() == 0 || UNKNOWN.equalsIgnoreCase(ip)) {
            ip = request.getHeader("WL-Proxy-Client-IP");
        }
        if (ip == null || ip.length() == 0 || UNKNOWN.equalsIgnoreCase(ip)) {
            ip = request.getRemoteAddr();
        }
        return "0:0:0:0:0:0:0:1".equals(ip) ? "127.0.0.1" : ip;
    }
}

