/*
 * Decompiled with CFR 0.152.
 */
package cn.soboys.restapispringbootstarter.controller;

import cn.soboys.restapispringbootstarter.Result;
import cn.soboys.restapispringbootstarter.ResultPage;
import cn.soboys.restapispringbootstarter.cache.CacheKey;
import cn.soboys.restapispringbootstarter.cache.RedisTempUtil;
import cn.soboys.restapispringbootstarter.domain.EntityParam;
import cn.soboys.restapispringbootstarter.enums.LogApiTypeEnum;
import cn.soboys.restapispringbootstarter.enums.LogCURDTypeEnum;
import cn.soboys.restapispringbootstarter.log.Log;
import cn.soboys.restapispringbootstarter.utils.RestFulTemp;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.dromara.hutool.core.bean.BeanUtil;
import org.dromara.hutool.core.map.MapUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.http.ResponseEntity;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Validated
public class ApiRestController {
    private static final Logger log = LoggerFactory.getLogger(ApiRestController.class);
    @Autowired
    private RedisTempUtil redisTempUtil;
    @Autowired
    private RestFulTemp restFulTemp;

    @PostMapping(value={"/chat"})
    public Result chatDialogue(@Validated EntityParam s) {
        return Result.buildSuccess(s);
    }

    @PostMapping(value={"/page"})
    @Log(value="\u67e5\u8be2\u7528\u6237\u6570\u636e", apiType=LogApiTypeEnum.USER, CURDType=LogCURDTypeEnum.RETRIEVE)
    public Result page(@Validated EntityParam s) {
        ResultPage resultPage = new ResultPage();
        ArrayList<EntityParam> a = new ArrayList<EntityParam>();
        a.add(s);
        resultPage.setPageData(a);
        return ResultPage.buildSuccess(resultPage);
    }

    @GetMapping(value={"/doDelete"})
    public Result doDelete() {
        this.restFulTemp.doDelete("http://127.0.0.1:8000/chat");
        return Result.buildSuccess();
    }

    @GetMapping(value={"/doPut"})
    public Result doPut() {
        EntityParam s = new EntityParam();
        this.restFulTemp.doPut("http://127.0.0.1:8000/chat", s);
        return Result.buildSuccess(s);
    }

    @PostMapping(value={"/doPost"})
    public Result doPostForm() {
        EntityParam s = new EntityParam();
        s.setAge(19);
        s.setHobby("swing");
        s.setName("judy");
        ResponseEntity<String> response = this.restFulTemp.doPostForm("http://127.0.0.1:8000/chat", BeanUtil.beanToMap((Object)s, (String[])new String[0]));
        return Result.buildSuccess(response.getBody());
    }

    @GetMapping(value={"/redis/unifyCache"})
    public Result unifyCacheKey() {
        CacheKey.PWD_RESET_CODE.valueSetAndExpire("test", 60L, TimeUnit.SECONDS, "judy");
        return Result.buildSuccess();
    }

    @GetMapping(value={"/redis/unifyCacheGet"})
    public Result unifyCacheGet() {
        String a = (String)CacheKey.PWD_RESET_CODE.valueGet("judy");
        return Result.buildSuccess(a);
    }

    @Cacheable(cacheNames={"testCache"}, keyGenerator="keyGeneratorStrategy")
    @GetMapping(value={"/redis/springCache"})
    public Result springCache() {
        String a = "test cache";
        return Result.buildSuccess(a);
    }

    @GetMapping(value={"/redis"})
    public Result redis() {
        this.redisTempUtil.set("bally", "123");
        return Result.buildSuccess();
    }

    @GetMapping(value={"/redisGet"})
    public Result redisGet() {
        return Result.buildSuccess(this.redisTempUtil.get("bally"));
    }

    @GetMapping(value={"/defind"})
    public Map defind() {
        HashMap m = MapUtil.newHashMap();
        m.put("name", "judy");
        m.put("age", 19);
        return m;
    }
}

