/*
 * Decompiled with CFR 0.152.
 */
package cn.soboys.restapispringbootstarter;

import cn.soboys.restapispringbootstarter.ResultCode;
import cn.soboys.restapispringbootstarter.domain.BaseObj;
import cn.soboys.restapispringbootstarter.i18n.DefaultMessage;
import cn.soboys.restapispringbootstarter.i18n.I18NMessage;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.servlet.http.HttpServletRequest;
import org.dromara.hutool.core.collection.CollUtil;
import org.dromara.hutool.core.data.id.IdUtil;
import org.dromara.hutool.core.date.DateUtil;
import org.dromara.hutool.core.text.StrUtil;
import org.dromara.hutool.extra.spring.SpringUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

@JsonPropertyOrder(value={"success", "code", "msg", "requestId", "timestamp", "data"})
public class Result<T>
extends BaseObj {
    private static final Logger log = LoggerFactory.getLogger(Result.class);
    public static final String SUCCESS_CODE = "OK";
    public static final String ERROR_CODE = "FAIL";
    public static final String MSG = "\u64cd\u4f5c\u6210\u529f";
    public static final String ERROR_MSG = "\u64cd\u4f5c\u5931\u8d25";
    private static final String TIMESTAMP = DateUtil.formatNow();
    private static final String I18N_HEADER = "Lang";
    private static final I18NMessage i18NMessage = (I18NMessage)SpringUtil.getBean(I18NMessage.class);
    private static final DefaultMessage defaultMessage = (DefaultMessage)SpringUtil.getBean(DefaultMessage.class);
    private Boolean success;
    private String code;
    private String msg;
    private String requestId = IdUtil.nanoId((int)20);
    private String timestamp = TIMESTAMP;
    private T data;

    public Result() {
    }

    public Result(Boolean success, String code, String msg, T data) {
        ServletRequestAttributes attributes = (ServletRequestAttributes)RequestContextHolder.getRequestAttributes();
        HttpServletRequest request = attributes.getRequest();
        if (CollUtil.isEmpty(i18NMessage.getMessage())) {
            i18NMessage.setMessage(defaultMessage.getMessage());
        } else {
            Map<String, Map<String, String>> result = Stream.of(i18NMessage.getMessage(), defaultMessage.getMessage()).flatMap(map -> map.entrySet().stream()).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, (v1, v2) -> v1));
            i18NMessage.setMessage(result);
        }
        this.success = success;
        this.code = code;
        this.msg = StrUtil.format((CharSequence)i18NMessage.message(msg, request.getHeader(i18NMessage.getI18nHeader())), (Object[])new Object[]{request.getAttribute("argument_error") == null ? "" : request.getAttribute("argument_error")});
        this.data = data;
    }

    public static <T> Result<T> build(Boolean success, ResultCode resultCode, T result) {
        return new Result<T>(success, resultCode.getCode(), resultCode.getMessage(), result);
    }

    public static <T> Result<T> build(Boolean success, String code, String msg, T result) {
        return new Result<T>(success, code, msg, result);
    }

    public static <T> Result<T> buildSuccess(String msg, T result) {
        return Result.build(Boolean.TRUE, SUCCESS_CODE, msg, result);
    }

    public static <T> Result<T> buildSuccess(T result) {
        return Result.build(Boolean.TRUE, SUCCESS_CODE, MSG, result);
    }

    public static <T> Result<T> buildSuccess() {
        return Result.build(Boolean.TRUE, SUCCESS_CODE, MSG, null);
    }

    public static <T> Result<T> buildFailure(String code, String msg, T result) {
        return Result.build(Boolean.FALSE, code, msg, result);
    }

    public static <T> Result<T> buildFailure(String code, String msg) {
        return Result.build(Boolean.FALSE, code, msg, null);
    }

    public static <T> Result<T> buildFailure(ResultCode resultCode, T result) {
        return Result.build(Boolean.FALSE, resultCode, result);
    }

    public static <T> Result<T> buildFailure(ResultCode resultCode) {
        return Result.build(Boolean.FALSE, resultCode, null);
    }

    public Boolean getSuccess() {
        return this.success;
    }

    public String getCode() {
        return this.code;
    }

    public String getMsg() {
        return this.msg;
    }

    public String getRequestId() {
        return this.requestId;
    }

    public String getTimestamp() {
        return this.timestamp;
    }

    public T getData() {
        return this.data;
    }

    public void setSuccess(Boolean success) {
        this.success = success;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public void setMsg(String msg) {
        this.msg = msg;
    }

    public void setRequestId(String requestId) {
        this.requestId = requestId;
    }

    public void setTimestamp(String timestamp) {
        this.timestamp = timestamp;
    }

    public void setData(T data) {
        this.data = data;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Result)) {
            return false;
        }
        Result other = (Result)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Boolean this$success = this.getSuccess();
        Boolean other$success = other.getSuccess();
        if (this$success == null ? other$success != null : !((Object)this$success).equals(other$success)) {
            return false;
        }
        String this$code = this.getCode();
        String other$code = other.getCode();
        if (this$code == null ? other$code != null : !this$code.equals(other$code)) {
            return false;
        }
        String this$msg = this.getMsg();
        String other$msg = other.getMsg();
        if (this$msg == null ? other$msg != null : !this$msg.equals(other$msg)) {
            return false;
        }
        String this$requestId = this.getRequestId();
        String other$requestId = other.getRequestId();
        if (this$requestId == null ? other$requestId != null : !this$requestId.equals(other$requestId)) {
            return false;
        }
        String this$timestamp = this.getTimestamp();
        String other$timestamp = other.getTimestamp();
        if (this$timestamp == null ? other$timestamp != null : !this$timestamp.equals(other$timestamp)) {
            return false;
        }
        T this$data = this.getData();
        T other$data = other.getData();
        return !(this$data == null ? other$data != null : !this$data.equals(other$data));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Result;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Boolean $success = this.getSuccess();
        result = result * 59 + ($success == null ? 43 : ((Object)$success).hashCode());
        String $code = this.getCode();
        result = result * 59 + ($code == null ? 43 : $code.hashCode());
        String $msg = this.getMsg();
        result = result * 59 + ($msg == null ? 43 : $msg.hashCode());
        String $requestId = this.getRequestId();
        result = result * 59 + ($requestId == null ? 43 : $requestId.hashCode());
        String $timestamp = this.getTimestamp();
        result = result * 59 + ($timestamp == null ? 43 : $timestamp.hashCode());
        T $data = this.getData();
        result = result * 59 + ($data == null ? 43 : $data.hashCode());
        return result;
    }

    public String toString() {
        return "Result(success=" + this.getSuccess() + ", code=" + this.getCode() + ", msg=" + this.getMsg() + ", requestId=" + this.getRequestId() + ", timestamp=" + this.getTimestamp() + ", data=" + this.getData() + ")";
    }
}

