/*
 * Decompiled with CFR 0.152.
 */
package cn.soboys.restapispringbootstarter.validator;

import cn.hutool.core.date.DateUtil;
import cn.hutool.core.text.StrFormatter;
import cn.hutool.core.util.NumberUtil;
import cn.hutool.core.util.StrUtil;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ValidatorUtil {
    private static final Pattern mobile_pattern = Pattern.compile("1\\d{10}");
    private static final Pattern money_pattern = Pattern.compile("^[0-9]+\\.?[0-9]{0,2}$");

    public static boolean isMobile(String src) {
        if (StrUtil.isBlank((CharSequence)src)) {
            return false;
        }
        Matcher m = mobile_pattern.matcher(src);
        return m.matches();
    }

    public static boolean isEnum(Class<?> beanClass, String status) throws Exception {
        if (StrUtil.isBlank((CharSequence)status)) {
            return false;
        }
        Class<?> clazz = beanClass;
        Enum[] enumConstants = (Enum[])clazz.getEnumConstants();
        Method getCode = clazz.getMethod("getCode", new Class[0]);
        Method getDesc = clazz.getMethod("getDesc", new Class[0]);
        for (Enum enums : enumConstants) {
            String instance = enums.name();
            String code = getCode.invoke((Object)enums, new Object[0]).toString();
            if (code.equals(status)) {
                return true;
            }
            String desc = getDesc.invoke((Object)enums, new Object[0]).toString();
            System.out.println(StrFormatter.format((String)"\u5b9e\u5217{}---code:{}desc{}", (Object[])new Object[]{instance, code, desc}));
        }
        return false;
    }

    public static boolean isMoney(BigDecimal money) {
        if (StrUtil.isEmptyIfStr((Object)money)) {
            return false;
        }
        if (!NumberUtil.isNumber((CharSequence)String.valueOf(money.doubleValue()))) {
            return false;
        }
        if (money.doubleValue() == 0.0) {
            return false;
        }
        Matcher m = money_pattern.matcher(String.valueOf(money.doubleValue()));
        return m.matches();
    }

    public static boolean isDateTime(String date, String dateFormat) {
        if (StrUtil.isBlank((CharSequence)date)) {
            return false;
        }
        try {
            DateUtil.parse((CharSequence)date, (String)dateFormat);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }
}

