/*
 * Decompiled with CFR 0.152.
 */
package cn.soboys.restapispringbootstarter.cache;

import cn.hutool.extra.spring.SpringUtil;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import javax.annotation.Resource;
import org.springframework.boot.autoconfigure.ImportAutoConfiguration;
import org.springframework.boot.autoconfigure.data.redis.RedisAutoConfiguration;
import org.springframework.context.annotation.Configuration;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.data.redis.core.ValueOperations;
import org.springframework.data.redis.support.atomic.RedisAtomicLong;

@ImportAutoConfiguration(value={RedisAutoConfiguration.class})
@Configuration(proxyBeanMethods=true)
public class RedisTempUtil {
    private static RedisTempUtil instance;
    @Resource
    private RedisTemplate redisTemplate;

    public static RedisTempUtil getInstance() {
        return (RedisTempUtil)SpringUtil.getBean(RedisTempUtil.class);
    }

    public Boolean hasKey(String key) {
        return this.redisTemplate.hasKey((Object)key);
    }

    public Boolean delete(String key) {
        return this.redisTemplate.delete((Object)key);
    }

    public boolean exists(String key) {
        return this.redisTemplate.hasKey((Object)key);
    }

    public Long getRemainingTime(String key) {
        ValueOperations ops = this.redisTemplate.opsForValue();
        return ops.getOperations().getExpire((Object)key);
    }

    public Long ttl(String key) {
        return this.redisTemplate.getExpire((Object)key);
    }

    public Collection<String> keys(String pattern) {
        return this.redisTemplate.keys((Object)pattern);
    }

    public Set<String> getAllKey(String keys) {
        Set key = this.redisTemplate.keys((Object)(keys + "*"));
        return key;
    }

    public void clean() {
        Set keys = this.redisTemplate.keys((Object)"*");
        this.redisTemplate.delete((Collection)keys);
    }

    public void cleanAllKey(String key) {
        Set keys = this.redisTemplate.keys((Object)(key + "*"));
        this.redisTemplate.delete((Collection)keys);
    }

    public boolean deleteObject(String key) {
        return this.redisTemplate.delete((Object)key);
    }

    public Long incr(String key) {
        RedisAtomicLong entityIdCounter = new RedisAtomicLong(key, Objects.requireNonNull(this.redisTemplate.getConnectionFactory()));
        return entityIdCounter.incrementAndGet();
    }

    public Long decr(String key) {
        RedisAtomicLong entityIdCounter = new RedisAtomicLong(key, Objects.requireNonNull(this.redisTemplate.getConnectionFactory()));
        return entityIdCounter.incrementAndGet();
    }

    public long deleteObject(Collection collection) {
        return this.redisTemplate.delete(collection);
    }

    public Boolean set(String key, Object value, Long time) {
        try {
            if (time > 0L) {
                this.redisTemplate.opsForValue().set((Object)key, value, time.longValue(), TimeUnit.SECONDS);
            } else {
                this.set(key, value);
            }
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public boolean expire(String key, long timeout) {
        return this.expire(key, timeout, TimeUnit.SECONDS);
    }

    public boolean expire(String key, long timeout, TimeUnit unit) {
        return this.redisTemplate.expire((Object)key, timeout, unit);
    }

    public void set(String key, Object value) {
        this.redisTemplate.opsForValue().set((Object)key, value);
    }

    public void set(String key, Object value, long timeout, TimeUnit unit) {
        this.redisTemplate.opsForValue().set((Object)key, value, timeout, unit);
    }

    public Object get(String key) {
        return this.redisTemplate.opsForValue().get((Object)key);
    }

    public void lPush(String key, Object value) {
        this.redisTemplate.opsForList().rightPush((Object)key, value);
    }

    public Object lPop(String key) {
        return this.redisTemplate.opsForList().leftPop((Object)key);
    }

    public List<Object> lRange(String key, long start, long end) {
        return this.redisTemplate.opsForList().range((Object)key, start, end);
    }

    public void sAdd(String key, Object ... values) {
        this.redisTemplate.opsForSet().add((Object)key, values);
    }

    public Set<Object> sMembers(String key) {
        return this.redisTemplate.opsForSet().members((Object)key);
    }

    public void hSet(String key, Map<String, Object> map) {
        this.redisTemplate.opsForHash().putAll((Object)key, map);
    }

    public Map<Object, Object> hGetAll(String key) {
        return this.redisTemplate.opsForHash().entries((Object)key);
    }

    public void zAdd(String key, Object value, double score) {
        this.redisTemplate.opsForZSet().add((Object)key, value, score);
    }

    public Set<Object> zRange(String key, long start, long end) {
        return this.redisTemplate.opsForZSet().range((Object)key, start, end);
    }
}

