/*
 * Decompiled with CFR 0.152.
 */
package cn.soboys.restapispringbootstarter.aop;

import cn.soboys.restapispringbootstarter.annotation.Limit;
import cn.soboys.restapispringbootstarter.aop.BaseAspectSupport;
import cn.soboys.restapispringbootstarter.enums.LimitType;
import cn.soboys.restapispringbootstarter.exception.LimitAccessException;
import cn.soboys.restapispringbootstarter.utils.HttpUserAgent;
import com.google.common.collect.ImmutableList;
import java.lang.reflect.Method;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.data.redis.core.script.DefaultRedisScript;
import org.springframework.data.redis.core.script.RedisScript;
import org.springframework.stereotype.Component;

@Aspect
@Component
public class LimitAspect
extends BaseAspectSupport {
    private static final Logger log = LoggerFactory.getLogger(LimitAspect.class);
    @Resource
    private RedisTemplate<String, Object> redisTemplate;

    @Pointcut(value="@annotation(cn.soboys.restapispringbootstarter.annotation.Limit)")
    public void pointcut() {
    }

    @Around(value="pointcut()")
    public Object around(ProceedingJoinPoint point) throws Throwable {
        String key;
        Method method = this.resolveMethod(point);
        Limit limitAnnotation = method.getAnnotation(Limit.class);
        LimitType limitType = limitAnnotation.limitType();
        String name = limitAnnotation.name();
        String ip = HttpUserAgent.getIpAddr();
        int limitPeriod = limitAnnotation.period();
        int limitCount = limitAnnotation.count();
        switch (limitType) {
            case IP: {
                key = ip;
                break;
            }
            case CUSTOMER: {
                key = limitAnnotation.key();
                break;
            }
            default: {
                key = StringUtils.upperCase((String)method.getName());
            }
        }
        ImmutableList keys = ImmutableList.of((Object)StringUtils.join((Object[])new String[]{limitAnnotation.prefix() + "_", key, ip}));
        String luaScript = this.buildLuaScript();
        DefaultRedisScript redisScript = new DefaultRedisScript(luaScript, Long.class);
        Long count = (Long)this.redisTemplate.execute((RedisScript)redisScript, (List)keys, new Object[]{limitCount, limitPeriod});
        if (count != null && count.intValue() <= limitCount) {
            log.info("IP:{} \u7b2c {} \u6b21\u8bbf\u95eekey\u4e3a {}\uff0c\u63cf\u8ff0\u4e3a [{}] \u7684\u63a5\u53e3", new Object[]{ip, count, keys, name});
            return point.proceed();
        }
        log.error("key\u4e3a {}\uff0c\u63cf\u8ff0\u4e3a [{}] \u7684\u63a5\u53e3\u8bbf\u95ee\u8d85\u51fa\u9891\u7387\u9650\u5236", (Object)keys, (Object)name);
        throw new LimitAccessException("\u8bbf\u95ee\u9891\u7387\u8fc7\u5feb\u8bf7\u7a0d\u540e\u518d\u8bd5");
    }

    private String buildLuaScript() {
        return "local c\nc = redis.call('get',KEYS[1])\nif c and tonumber(c) > tonumber(ARGV[1]) then\nreturn c;\nend\nc = redis.call('incr',KEYS[1])\nif tonumber(c) == 1 then\nredis.call('expire',KEYS[1],ARGV[2])\nend\nreturn c;";
    }
}

