/*
 * Decompiled with CFR 0.152.
 */
package cn.sntumc.utils;

import java.beans.BeanInfo;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import java.util.Map;

public class MapUtil {
    public static Object mapToObject(Map<Object, Object> map, Class<?> beanClass) throws Exception {
        Field[] fields;
        if (map == null) {
            return null;
        }
        Object obj = beanClass.newInstance();
        for (Field field : fields = obj.getClass().getDeclaredFields()) {
            int mod = field.getModifiers();
            if (Modifier.isStatic(mod) || Modifier.isFinal(mod)) continue;
            field.setAccessible(true);
            if (!map.containsKey(field.getName())) continue;
            field.set(obj, map.get(field.getName()));
        }
        return obj;
    }

    public static Map<String, Object> objectToMap(Object obj) throws Exception {
        PropertyDescriptor[] propertyDescriptors;
        if (obj == null) {
            return null;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        BeanInfo beanInfo = Introspector.getBeanInfo(obj.getClass());
        for (PropertyDescriptor property : propertyDescriptors = beanInfo.getPropertyDescriptors()) {
            String key = property.getName();
            if (key.compareToIgnoreCase("class") == 0) continue;
            Method getter = property.getReadMethod();
            Object value = getter != null ? getter.invoke(obj, new Object[0]) : null;
            map.put(key, value);
        }
        return map;
    }
}

