/*
 * Decompiled with CFR 0.152.
 */
package cn.sntumc.utils;

import java.lang.reflect.Field;
import java.lang.reflect.Method;

public class BeanUtil {
    public static void toBean(Object filterBean, Object targetBean) throws Exception {
        Class<?> filterClass = Class.forName(filterBean.getClass().getName());
        Class<?> targetClass = Class.forName(targetBean.getClass().getName());
        Field[] fields1 = filterClass.getDeclaredFields();
        Field[] fields2 = targetClass.getDeclaredFields();
        for (Field f1 : fields1) {
            Object value = BeanUtil.invokeGetMethod(filterBean, f1.getName(), null);
            for (Field f2 : fields2) {
                if (!f1.getName().equals(f2.getName())) continue;
                Object[] obj = new Object[]{value};
                BeanUtil.invokeSetMethod(targetBean, f2.getName(), obj);
            }
        }
    }

    private static Object invokeGetMethod(Object filterBean, String fieldName, Object[] args) {
        String methodName = fieldName.substring(0, 1).toUpperCase() + fieldName.substring(1);
        Method method = null;
        try {
            method = Class.forName(filterBean.getClass().getName()).getDeclaredMethod("get" + methodName, new Class[0]);
            return method.invoke(filterBean, new Object[0]);
        }
        catch (Exception e) {
            e.printStackTrace();
            return "";
        }
    }

    private static Object invokeSetMethod(Object targetBean, String fieldName, Object[] args) {
        String methodName = fieldName.substring(0, 1).toUpperCase() + fieldName.substring(1);
        Method method = null;
        try {
            Class[] parameterTypes = new Class[1];
            Class<?> targetClass = Class.forName(targetBean.getClass().getName());
            Field field = targetClass.getDeclaredField(fieldName);
            parameterTypes[0] = field.getType();
            method = targetClass.getDeclaredMethod("set" + methodName, parameterTypes);
            return method.invoke(targetBean, args);
        }
        catch (Exception e) {
            e.printStackTrace();
            return "";
        }
    }
}

