/*
 * Decompiled with CFR 0.152.
 */
package cn.sntumc.model;

import cn.sntumc.enums.ResCodeStatus;
import cn.sntumc.enums.StatusEnum;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;

public class ResModel {
    public static Gson gson = new GsonBuilder().setDateFormat("yyyy-MM-dd HH:mm:ss").create();
    private StatusEnum status;
    private ResCodeStatus codeStatus;
    private String message;
    private String data;
    private String sessionId;
    private String authKey;
    private String code;

    public ResModel() {
    }

    public ResModel(StatusEnum status, ResCodeStatus codeStatus) {
        this.status = status;
        this.codeStatus = codeStatus;
        this.data = null;
    }

    public static String OK() {
        return new ResModel(StatusEnum.SUCCESS, ResCodeStatus.OTHER_SUCCESS).toString();
    }

    public static String OK(ResCodeStatus resCodeStatus) {
        return new ResModel(StatusEnum.SUCCESS, resCodeStatus).toString();
    }

    public static String OK(ResCodeStatus resCodeStatus, Object data) {
        return new ResModel(StatusEnum.SUCCESS, resCodeStatus, data).toString();
    }

    public static String OK(Object data) {
        return new ResModel(StatusEnum.SUCCESS, ResCodeStatus.OTHER_SUCCESS, data).toString();
    }

    public static String FAIL(ResCodeStatus codeStatus, String message) {
        return new ResModel(StatusEnum.ERROR, codeStatus, message).toString();
    }

    public static String FAIL() {
        return new ResModel(StatusEnum.ERROR, ResCodeStatus.OTHER_ERROR).toString();
    }

    public static String FAIL(ResCodeStatus status) {
        return new ResModel(StatusEnum.ERROR, status).toString();
    }

    public static String PUSH(boolean status, String code, String message, Object ... data) {
        ResModel resModel = new ResModel();
        resModel.message = message;
        resModel.code = code;
        resModel.status = status ? StatusEnum.SUCCESS : StatusEnum.ERROR;
        if (null != data && data.length > 0) {
            resModel.setData(data[0]);
        }
        return resModel.toString();
    }

    public ResModel(StatusEnum status, ResCodeStatus codeStatus, Object data) {
        this.status = status;
        this.codeStatus = codeStatus;
        this.data = data instanceof String ? data.toString() : gson.toJson(data);
    }

    public ResModel(String message, StatusEnum status) {
        this.status = status;
        this.message = message;
        this.codeStatus = status == StatusEnum.ERROR ? ResCodeStatus.OTHER_ERROR : ResCodeStatus.OTHER_SUCCESS;
    }

    public ResModel(StatusEnum status, ResCodeStatus codeStatus, String data) {
        this.status = status;
        this.codeStatus = codeStatus;
        this.data = data;
    }

    public ResModel(StatusEnum status, ResCodeStatus code, String message, Object data) {
        this.status = status;
        this.codeStatus = code;
        this.message = message;
        this.data = gson.toJson(data);
    }

    public ResModel(StatusEnum status, ResCodeStatus codeStatus, String message, String data) {
        this.status = status;
        this.codeStatus = codeStatus;
        this.message = message;
        this.data = data;
    }

    public void setData(Object data) {
        this.data = gson.toJson(data);
    }

    public String toString() {
        String codes = "";
        codes = null == this.code || "".equals(this.code) ? this.codeStatus.getCode() : this.code;
        String ret = "{\"status\":" + this.status.isStatus() + ",\"code\":\"" + codes + "\",\"message\":\"" + (null == this.message || "".equals(this.message) ? this.codeStatus.getMessage() : this.message) + "\",\"datas\":" + (null == this.data || "".equals(this.data) ? null : this.data) + "}";
        return ret;
    }

    public StatusEnum getStatus() {
        return this.status;
    }

    public ResCodeStatus getCodeStatus() {
        return this.codeStatus;
    }

    public String getMessage() {
        return this.message;
    }

    public String getData() {
        return this.data;
    }

    public String getSessionId() {
        return this.sessionId;
    }

    public String getAuthKey() {
        return this.authKey;
    }

    public String getCode() {
        return this.code;
    }

    public void setStatus(StatusEnum status) {
        this.status = status;
    }

    public void setCodeStatus(ResCodeStatus codeStatus) {
        this.codeStatus = codeStatus;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public void setSessionId(String sessionId) {
        this.sessionId = sessionId;
    }

    public void setAuthKey(String authKey) {
        this.authKey = authKey;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ResModel)) {
            return false;
        }
        ResModel other = (ResModel)o;
        if (!other.canEqual(this)) {
            return false;
        }
        StatusEnum this$status = this.getStatus();
        StatusEnum other$status = other.getStatus();
        if (this$status == null ? other$status != null : !((Object)((Object)this$status)).equals((Object)other$status)) {
            return false;
        }
        ResCodeStatus this$codeStatus = this.getCodeStatus();
        ResCodeStatus other$codeStatus = other.getCodeStatus();
        if (this$codeStatus == null ? other$codeStatus != null : !((Object)((Object)this$codeStatus)).equals((Object)other$codeStatus)) {
            return false;
        }
        String this$message = this.getMessage();
        String other$message = other.getMessage();
        if (this$message == null ? other$message != null : !this$message.equals(other$message)) {
            return false;
        }
        String this$data = this.getData();
        String other$data = other.getData();
        if (this$data == null ? other$data != null : !this$data.equals(other$data)) {
            return false;
        }
        String this$sessionId = this.getSessionId();
        String other$sessionId = other.getSessionId();
        if (this$sessionId == null ? other$sessionId != null : !this$sessionId.equals(other$sessionId)) {
            return false;
        }
        String this$authKey = this.getAuthKey();
        String other$authKey = other.getAuthKey();
        if (this$authKey == null ? other$authKey != null : !this$authKey.equals(other$authKey)) {
            return false;
        }
        String this$code = this.getCode();
        String other$code = other.getCode();
        return !(this$code == null ? other$code != null : !this$code.equals(other$code));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ResModel;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        StatusEnum $status = this.getStatus();
        result = result * 59 + ($status == null ? 43 : ((Object)((Object)$status)).hashCode());
        ResCodeStatus $codeStatus = this.getCodeStatus();
        result = result * 59 + ($codeStatus == null ? 43 : ((Object)((Object)$codeStatus)).hashCode());
        String $message = this.getMessage();
        result = result * 59 + ($message == null ? 43 : $message.hashCode());
        String $data = this.getData();
        result = result * 59 + ($data == null ? 43 : $data.hashCode());
        String $sessionId = this.getSessionId();
        result = result * 59 + ($sessionId == null ? 43 : $sessionId.hashCode());
        String $authKey = this.getAuthKey();
        result = result * 59 + ($authKey == null ? 43 : $authKey.hashCode());
        String $code = this.getCode();
        result = result * 59 + ($code == null ? 43 : $code.hashCode());
        return result;
    }
}

