package cn.sntumc.utils;



import cn.sntumc.model.SntuPayModel;
import com.google.gson.Gson;
import org.apache.commons.codec.binary.Base64;

import javax.crypto.Cipher;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.PublicKey;
import java.security.spec.X509EncodedKeySpec;
import java.util.Arrays;
import java.util.Map;

/**
 * 支付常用
 */
public class PayUtil {

    /**
     * 获取公钥和私钥
     * @return
     */
    public static Map<String,String> getKey(){
        try {
            return RSAEncrypt.genKeyPair();
        } catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
            return null;
        }
    }
    /**
     * 加密
     * @param data
     * @param publicKey
     * @return
     */
    public static String encrypt(String data,String publicKey){

        String messageEn = null;
        try {
            messageEn = RSAEncrypt.encryptLong(data,publicKey);
        } catch (Exception e) {
            e.printStackTrace();
        }
        return messageEn;
    }
    public static String decrypt(String data,String privateKey){
        String dataDec = null;
        try {
            dataDec = RSAEncrypt.decryptLong(data,privateKey);
        } catch (Exception e) {
            e.printStackTrace();
        }
        return dataDec;
    }


    /**
     * 解析返回值
     * @param json
     * @return 返回值对象
     */
    public static SntuPayModel analysisModel(String json) {
       try{
           return new Gson().fromJson(json,SntuPayModel.class);
       }catch (Exception e){
           return null;
       }
    }

}