package cn.sntumc.model;


import cn.sntumc.utils.MapUtil;
import cn.sntumc.utils.StringUtil;
import com.google.gson.Gson;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.*;

/**
 * Created by sing on 2018/9/19.
 * 统一模板
 * <p>
 * Author: Huiyuzhe
 */

@Builder
@AllArgsConstructor
public class SntuData extends HashMap implements Map {

    private Map sntuData=null;

    public SntuData(){
        sntuData= new HashMap();
    }

    public int size() {
        return sntuData.size();
    }

    public boolean isEmpty() {
        return sntuData.isEmpty();
    }

    public boolean containsKey(Object key) {
        return sntuData.containsKey(key);
    }

    public boolean containsValue(Object value) {
        return sntuData.containsValue(value);
    }

    public Object get(Object key) {
        return sntuData.get(key);
    }

    public String getString(Object key) {
        return StringUtil.getString(sntuData.get(key));
    }

    public Integer getInt(Object key) {
        String str = getString(key);
        return StringUtil.isEmpty(str) ? null : Integer.parseInt(str);
    }

    public Object put(Object key, Object value) {
        return this.sntuData.put(key,value);
    }

    public Object remove(Object key) {
        return this.sntuData.remove(key);
    }

    public void putAll(Map m) {
        this.sntuData.putAll(m);
    }

    public void clear() {
        this.sntuData.clear();
    }

    public Set keySet() {
        return this.sntuData.keySet();
    }

    public Collection values() {
        return this.sntuData.values();
    }

    public Set<Entry> entrySet() {
        return this.sntuData.entrySet();
    }


    public static SntuData toSntuData(Object obj) throws Exception {
        if(obj == null)
            return null;
        SntuData sntuData = new SntuData();
        BeanInfo beanInfo = Introspector.getBeanInfo(obj.getClass());
        PropertyDescriptor[] propertyDescriptors = beanInfo.getPropertyDescriptors();
        for (PropertyDescriptor property : propertyDescriptors) {
            String key = property.getName();
            if (key.compareToIgnoreCase("class") == 0) {
                continue;
            }
            Method getter = property.getReadMethod();
            Object value = getter!=null ? getter.invoke(obj) : null;
            sntuData.put(key, value);
        }

        return sntuData;
    }

    public  <T> T toBean(Class<?> beanClass){
        try {
            return (T) MapUtil.mapToObject(this,beanClass);
        } catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public  String toJson(){
        try {
            return new Gson().toJson(this);
        } catch (Exception e) {
            e.printStackTrace();
            return null;
        }

    }

    public static void main(String[] args) throws Exception {
        SntuData sntuData=new SntuData();
        sntuData.put("code","1");
        sntuData.put("msg","123123132131");
        SntuPayModel test =sntuData.toBean(SntuPayModel.class);
        System.out.println(test.getMsg());
        System.out.println(sntuData.toJson());
        SntuData sntuData1=SntuData.toSntuData(test);
        System.out.println(sntuData1.get("code"));
    }
}