package cn.sntumc.model;


import cn.sntumc.enums.ResCodeStatus;
import cn.sntumc.enums.StatusEnum;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;

import lombok.Data;

/**
 * 统一返回格式
 */
@Data
public class ResModel {

    public ResModel(){


    }
    public ResModel(StatusEnum status, ResCodeStatus codeStatus){
        this.status=status;
        this.codeStatus=codeStatus;
        this.data=null;
    }
    public static Gson gson = new GsonBuilder().setDateFormat("yyyy-MM-dd HH:mm:ss").create();
    //快速返回
    public static String OK(){
        return new ResModel(StatusEnum.SUCCESS,ResCodeStatus.OTHER_SUCCESS).toString();
    }
    public static String OK(ResCodeStatus resCodeStatus){
        return new ResModel(StatusEnum.SUCCESS,resCodeStatus).toString();
    }
    public static String OK(ResCodeStatus resCodeStatus,Object data){
        return new ResModel(StatusEnum.SUCCESS,resCodeStatus,data).toString();
    }
    //快速返回含数据的
    public  static String OK(Object data){
        return new ResModel(StatusEnum.SUCCESS,ResCodeStatus.OTHER_SUCCESS,data).toString();
    }


    public  static String FAIL(ResCodeStatus codeStatus, String message){
        return new ResModel(StatusEnum.ERROR,codeStatus,message).toString();
    }
    public static String FAIL(){
        return new ResModel(StatusEnum.ERROR,ResCodeStatus.OTHER_ERROR).toString();
    }
    public static String FAIL(ResCodeStatus status){
        return new ResModel(StatusEnum.ERROR,status).toString();
    }

    public  static String PUSH(boolean status,String code,String message,Object... data){
        ResModel resModel=new ResModel();
        resModel.message = message;

        resModel.code=code;
        if(status){
            resModel.status=StatusEnum.SUCCESS;
        }else{
            resModel.status=StatusEnum.ERROR;
        }
        if(null!=data&&data.length>0){
            resModel.setData(data[0]);
        }
        return  resModel.toString();

    }


    /**
     *
     * @param status   ；
     * @param codeStatus
     * @param data
     */
    public ResModel(StatusEnum status, ResCodeStatus codeStatus, Object data){
        this.status=status;
        this.codeStatus=codeStatus;
        if(data instanceof String){
            this.data= data.toString();
        }else{
            this.data=gson.toJson(data);
        }

    }
    public ResModel(String message,StatusEnum status){
        this.status=status;
        this.message=message;
        if(status==StatusEnum.ERROR){
            this.codeStatus=ResCodeStatus.OTHER_ERROR;
        }else{
            this.codeStatus=ResCodeStatus.OTHER_SUCCESS;
        }

    }
    public ResModel(StatusEnum status, ResCodeStatus codeStatus, String data){
        this.status=status;
        this.codeStatus=codeStatus;
        this.data=data;
    }
    public ResModel(StatusEnum status, ResCodeStatus code, String message, Object data){
        this.status=status;
        this.codeStatus=code;
        this.message=message;
        this.data=gson.toJson(data);
    }

    public ResModel(StatusEnum status, ResCodeStatus codeStatus, String message, String data){
        this.status=status;
        this.codeStatus=codeStatus;
        this.message=message;
        this.data=data;
    }
    private StatusEnum status;
    private ResCodeStatus codeStatus;
    private String message;
    private String data;
    private String sessionId;
    private String authKey;
    private String code;

    public void setData(Object data){
        this.data= gson.toJson(data);
    }

    @Override
    public String toString(){
        String codes="";
        if(null==code||"".equals(code)){
            codes=codeStatus.getCode();
        }else{
            codes=code;
        }
        String ret= "{\"status\":"+status.isStatus()+",\"code\":\""+codes+"\",\"message\":\""+((null==message||"".equals(message))?codeStatus.getMessage():message)+"\",\"datas\":"+((null==data||"".equals(data))?null:data)+"}";
        //return StringUtil.setDecryptParam(ret);
        return ret;
    }
}
