package cn.sntumc.http;

import cn.sntumc.utils.SSLClientUtil;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.entity.StringEntity;
import org.apache.http.message.BasicHeader;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.util.EntityUtils;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

/**
 * https 请求工具类
 */
public class HttpsClient {

    /**
     * 请求 https
     * @param url 请求地址
     * @param jsonstr json入参
     * @param charset 编码
     * @return 请求返回值
     */
    @SuppressWarnings("resource")
    public static String doPostHttps(String url,String jsonstr,String charset){
        org.apache.http.client.HttpClient httpClient = null;
        HttpPost httpPost = null;
        String result = null;
        try{
            httpClient = new SSLClientUtil();
            httpPost = new HttpPost(url);
            httpPost.addHeader("Content-Type", "application/json");
            StringEntity se = new StringEntity(jsonstr);
            se.setContentType("text/json");
            se.setContentEncoding(new BasicHeader("Content-Type", "application/json"));
            httpPost.setEntity(se);
            HttpResponse response = httpClient.execute(httpPost);
            if(response != null){
                HttpEntity resEntity = response.getEntity();
                if(resEntity != null){
                    result = EntityUtils.toString(resEntity,charset);
                }
            }
        }catch(Exception ex){
            ex.printStackTrace();
        }
        return result;
    }

    /**
     *post请求
     * @param url 请求地址
     * @param params 请求参数
     * @return 请求返回值
     * @throws Exception 请求失败
     */
    @SuppressWarnings("unchecked")
    public static String post(String url, Map<String, String> params)
            throws Exception {
        org.apache.http.client.HttpClient httpClient = new SSLClientUtil();
        HttpPost post = new HttpPost(url);
        List data = null;
        if (params != null) {
            data = new ArrayList(params.size());
            for (Map.Entry entry : params.entrySet()) {
                data.add(new BasicNameValuePair((String) entry.getKey(),
                        (String) entry.getValue()));
            }
            UrlEncodedFormEntity formEntity = new UrlEncodedFormEntity(data,
                    "UTF-8");
            post.setEntity(formEntity);
        }
        //  log.info("http post---{}", getUrlRequestInfo(url, params));
        HttpResponse response;
        try {
            response = httpClient.execute(post);
            String result = EntityUtils.toString(response.getEntity());
            return result;
        } catch (ClientProtocolException e) {
            e.printStackTrace();
        } catch (IOException e) {
            e.printStackTrace();
        } finally {
            httpClient.getConnectionManager().shutdown();
        }
        return null;
    }
}
