package cn.sntumc.utils;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.DecimalFormat;
import java.text.NumberFormat;

public class ValidUtil {

    /**
     * 占比计算保留小数的位数方法
     * 转成百分数
     * 当前数除以总数
     * @param  num1 ,num2  num1/num2
     * @return  rate  保留2位小数的
     */
    public static String  division(int num1,int num2){
        String rate="0.00%";
        //定义格式化起始位数
        String format="0.00";
        if(num2 != 0 && num1 != 0){
            DecimalFormat dec = new DecimalFormat(format);
            rate =  dec.format((double) num1 / num2*100)+"%";
            while(true){
                if(rate.equals(format+"%")){
                    format=format+"0";
                    DecimalFormat dec1 = new DecimalFormat(format);
                    rate =  dec1.format((double) num1 / num2*100)+"%";
                }else {
                    break;
                }
            }
        }else if(num1 != 0 && num2 == 0){
            rate = "100%";
        }
        return rate;
    }

    /**
     * 把上面得到的百分比转为字符串类型的小数  保留两位小数
     * @param percent 要转换的字符串
     * @return 转换后的小数
     */
    public static BigDecimal perToDecimal(String percent){
        String decimal = percent.substring(0,percent.indexOf("%"));
        BigDecimal bigDecimal = new BigDecimal(decimal);
        bigDecimal.divide(new BigDecimal("100"), 4, BigDecimal.ROUND_HALF_UP);
        return bigDecimal;
    }


    /**
     * 小数转百分比
     * @param value 要转换的字符串
     * @return 转换后的百分比
     */
    public static String getDecimalToPercent(String value) {
        NumberFormat nf = NumberFormat.getPercentInstance();
        nf.setMaximumFractionDigits(2);//这个2的意识是保存结果到小数点后几位，但是特别声明：这个结果已经先＊100了。
        String str="0";
        if (!StringUtil.isEmpty(value)) {
            try {
                str=nf.format(Double.parseDouble(value));
            } catch (Exception e) {
                e.printStackTrace();
                str="0";
            }
        }
        return str;
    }

    /**
     * 百分号转小数 85.3% 转成 0.853
     * @param value 百分数
     * @return 转换后的小数
     */
    public static String getPercentToDecimal(String value) {
        NumberFormat nt = NumberFormat.getPercentInstance();
        nt.setRoundingMode(RoundingMode.HALF_UP); //设置满5向上进位，即四舍五入;
        nt.setMinimumIntegerDigits(4);
        nt.setMaximumFractionDigits(2);
        String str="";
        if (!StringUtil.isEmpty(value)) {
            if (!value.contains("%")) {
                value = value + "%";
            }
            Number nm = null;
            try {
                nm = nt.parse(value);
                // 保留4位小数
                DecimalFormat formater = new DecimalFormat("0.0000");
                // 四舍五入
                formater.setRoundingMode(RoundingMode.HALF_UP);
                str = formater.format(nm);
            } catch (Exception e) {
                e.printStackTrace();
                str="0";
            }
        }else{
            str="0";
        }
        return str;
    }

    /**
     * 四舍五入保留2位小数
     * @param value 要转换的数
     * @return 转换后的数
     */
    public static String getRoundingNumTwo(String value){
        String str="";
        if (!StringUtil.isEmpty(value)) {
            // 保留2位小数
            DecimalFormat formater = new DecimalFormat("0.00");
            // 四舍五入
            formater.setRoundingMode(RoundingMode.HALF_UP);
            str = formater.format(value);
        }
        return str;
    }
    /**
     * 四舍五入保留4位小数
     * @param value 要转换的数
     * @return 转换后的数
     */
    public static String getRoundingNumfour(String value){
        String str="";
        if (!StringUtil.isEmpty(value)) {
            // 保留2位小数
            DecimalFormat formater = new DecimalFormat("0.0000");
            // 四舍五入
            formater.setRoundingMode(RoundingMode.HALF_UP);
            str = formater.format(value);
        }
        return str;
    }
}
