package cn.sntumc.utils;

import java.text.DateFormat;
import java.text.ParseException;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
/**
 * Time操作类
 * @author Huiyuzhe
 */
public class TimeUtil {
    public static String DATE_YYYY_MM_SS="yyyy-MM-dd HH:mm:ss";

    /**
     * 根据格式返回当前时间 yyyy-MM-dd HH:mm:ss
     * @return  根据格式返回当前时间 yyyy-MM-dd HH:mm:ss
     */
    public static String  getNowDate(){
        SimpleDateFormat formatter = new SimpleDateFormat(DATE_YYYY_MM_SS);
        return formatter.format( new Date());
    }

    /**
     * 判断time是否在from，to之内
     *
     * @param time 指定日期
     * @param from 开始日期
     * @param to   结束日期
     * @return 是否通过
     */
    public static boolean belongCalendar(Date time, Date from, Date to) {
        Calendar date = Calendar.getInstance();
        date.setTime(time);

        Calendar after = Calendar.getInstance();
        after.setTime(from);

        Calendar before = Calendar.getInstance();
        before.setTime(to);

        if (date.after(after) && date.before(before)) {
            return true;
        } else {
            return false;
        }
    }

    /**
     * 判断time是否在from，to之内
     *
     * @param time 指定日期
     * @param from 开始日期
     * @param to   结束日期
     * @return 是否通过
     */
    public static boolean belongCalendar(String time, String from, String to) throws ParseException {
        Calendar date = Calendar.getInstance();
        date.setTime(stringToDate(time,DATE_YYYY_MM_SS));

        Calendar after = Calendar.getInstance();
        after.setTime(stringToDate(from,DATE_YYYY_MM_SS));

        Calendar before = Calendar.getInstance();
        before.setTime(stringToDate(to,DATE_YYYY_MM_SS));

        if (date.after(after) && date.before(before)) {
            return true;
        } else {
            return false;
        }
    }
    /**
     * 描述:获取下几个月.当前时间开始
     * @param count 月
     * @return 获取当前count月后的时间
     */
    public static String getPreMonth(Integer count) {
        Calendar cal = Calendar.getInstance();
        cal.add(cal.MONTH, count);
        SimpleDateFormat dft = new SimpleDateFormat(DATE_YYYY_MM_SS);
        String preMonth = dft.format(cal.getTime());
        return preMonth;
    }

    /**
     * 描述:获取某个时间的下几个月.
     * @param time 指定的时间
     * @param count 月数
     * @return 获取指定count月后的时间
     */
    public static String getPreMonthByDate(String time,Integer count) throws ParseException {
        Calendar cal = Calendar.getInstance();
        cal.setTime(stringToDate(time,DATE_YYYY_MM_SS));
        cal.add(cal.MONTH, count);
        SimpleDateFormat dft = new SimpleDateFormat(DATE_YYYY_MM_SS);
        String preMonth = dft.format(cal.getTime());
        return preMonth;
    }


    /**
     * 获取某个时间后某天的时间（当前时间）
     * @param days 天数
     * @return 计算后的时间
     */
    public static String getPreDays(Integer days){
        Calendar cal = Calendar.getInstance();
        cal.add(Calendar.DATE, days);
        Date date = cal.getTime();
        SimpleDateFormat format = new SimpleDateFormat(DATE_YYYY_MM_SS);
        return format.format(date);
    }

    /**
     * 获取某个时间后某天的时间（指定时间）
     * @param timeStr 指定时间
     * @param days  天数
     * @return 计算后的时间
     * @throws ParseException 时间转换异常
     */
    public static String getPreDaysByDay(String timeStr,Integer days) throws ParseException {
        Calendar cal = Calendar.getInstance();
        SimpleDateFormat format = new SimpleDateFormat(DATE_YYYY_MM_SS);
        cal.setTime(format.parse(timeStr));
        cal.add(Calendar.DATE, days);
        Date date = cal.getTime();
        return format.format(date);
    }
    /**
     * 判断 指定时间是否超过当前时间
     * @param time  指定的时间
     * @return true=没超过当前时间
     */
    public static boolean afterDays(String time) throws ParseException {
        SimpleDateFormat format = new SimpleDateFormat(DATE_YYYY_MM_SS);
        Date date1 = format.parse(time);
        if(date1.after(new Date())) {
            return  true;
        }
        else {
            return false;
        }
    }

    /**
     * 获得2个时间段的 相隔天数
     * @param startTime 开始时间
     * @param endTime 结束时间
     * @return 相隔的天数
     * @throws ParseException 时间转换异常
     */
    public static Integer getTwoTimeDays(String startTime,String endTime) throws ParseException {
        SimpleDateFormat format = new SimpleDateFormat(DATE_YYYY_MM_SS);
        Date date1 = format.parse(endTime);
        Date date2 = format.parse(startTime);
        return  (int) ((date1.getTime() - date2.getTime()) / (1000*3600*24));
    }

    /**
     * 时间戳转日期
     * @param ms 时间戳
     * @return 转换后的日期
     */
    public static String transForDate(Long ms){
        if(ms==null){
            ms=0L;
        }
        long msl=ms*1000;
        SimpleDateFormat sdf=new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        String str=null;
        if(ms!=null){
            str=sdf.format(msl);
            // temp=sdf.parse(str);
        }
        return str;
    }
    /**
     * 时间戳转日期（指定返回时间格式）
     * @param ms 时间戳
     * @param format 指定返回时间格式
     * @return 转换后的日期
     */
    public static String transForDate(Long ms,String format){
        if(ms==null){
            ms=0L;
        }
        long msl=ms*1000;
        SimpleDateFormat sdf=new SimpleDateFormat(format);
        String str=null;
        if(ms!=null){
            str=sdf.format(msl);
            // temp=sdf.parse(str);
        }
        return str;
    }


    /**
     * 计算两个日期之间相差的天、时、分、秒
     * @param first 开始时间
     * @param second 结束时间
     * @return 天、时、分、秒
     * @throws ParseException 转换异常
     */
    public static Long daysBetweenDay(Date first, Date second) throws ParseException {
        SimpleDateFormat sformat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        if(null==first){
            first=new Date();
        }
        if(null==second){
            second=new Date();
        }
        first = sformat.parse(sformat.format(first));
        second = sformat.parse(sformat.format(second));
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(first);
        long firstMills = calendar.getTimeInMillis();
        calendar.setTime(second);
        long secondMills = calendar.getTimeInMillis();
        long rateD = 1000 * 60 * 60 * 24;
        long rateH = 1000 * 60 * 60;
        long rateM = 1000 * 60;
        long rateS = 1000;
        long mills = secondMills - firstMills;
        long days = mills / rateD;
        long hours = (mills % rateD) / rateH;
        long minutes = (mills % rateD % rateH) / rateM;
        long seconds = (mills % rateD % rateH % rateM) / rateS;
        //log.info("最后运行时间与当前时间时差:" + days + "天" + hours + "时" + minutes + "分" + seconds + "秒");
        return minutes;
    }
    /**
     * 根据格式返回当前时间
     * @param match 格式 如 yyyy-MM-dd HH:mm:ss
     * @return 当前时间
     */
    public static String  formatThisTimeByMatch(String match){
        SimpleDateFormat formatter = new SimpleDateFormat(match);
        return formatter.format( new Date());
    }


    /**
     * date类型转换为String类型时间
     * @param data 转换的时间
     * @param formatType 时间格式
     * @return 转换后的时间
     */
    public static String dateToString(Date data, String formatType) {
        return new SimpleDateFormat(formatType).format(data);
    }

    /**
     * 将时间戳转换为String类型时间
     * @param currentTime 时间戳
     * @param formatType 时间格式
     * @return 转换后的时间
     * @throws ParseException 转换异常
     */
    public static String longToString(long currentTime, String formatType)
            throws ParseException {
        Date date = longToDate(currentTime, formatType); // long类型转成Date类型
        String strTime = dateToString(date, formatType); // date类型转成String
        return strTime;
    }

    /**
     * 将string时间转为Date
     * @param strTime 转换的时间 格式必须要与formatType的时间格式相同
     * @param formatType 格式
     * @return date类型时间
     * @throws ParseException 转换异常
     */
    public static Date stringToDate(String strTime, String formatType)
            throws ParseException {
        SimpleDateFormat formatter = new SimpleDateFormat(formatType);
        Date date = null;
        date = formatter.parse(strTime);
        return date;
    }

    /**
     * 将时间戳转为 date类型
     * @param currentTime e要转换的long类型的时间戳
     * @param formatType  格式
     * @return 转换后的 Date
     * @throws ParseException 转换异常
     */
    public static Date longToDate(long currentTime, String formatType)
            throws ParseException {
        Date dateOld = new Date(currentTime); // 根据long类型的毫秒数生命一个date类型的时间
        String sDateTime = dateToString(dateOld, formatType); // 把date类型的时间转换为string
        Date date = stringToDate(sDateTime, formatType); // 把String类型转换为Date类型
        return date;
    }

//    public static Date strToDateLong(String strDate,String formatStr) {
//        SimpleDateFormat formatter = new SimpleDateFormat(formatStr);
//        ParsePosition pos = new ParsePosition(0);
//        Date strtodate = formatter.parse(strDate, pos);
//        return strtodate;
//    }

    /**
     * 将String类型时间转为时间戳
     * @param strTime String类型时间
     * @param formatType String类型时间格式
     * @return 时间戳
     * @throws ParseException 转换异常
     */
    public static long stringToLong(String strTime, String formatType)
            throws ParseException {
        Date date = stringToDate(strTime, formatType); // String类型转成date类型
        if (date == null) {
            return 0;
        } else {
            long currentTime = dateToLong(date); // date类型转成long类型
            return currentTime;
        }
    }

    /**
     * date类型转换为long类型
     * @param date 要转换的时间
     * @return 时间戳
     */
    public static long dateToLong(Date date) {
        return date.getTime();
    }


    /**
     * 获取某个时间中的任意秒后的时间
     * @param time 知道时间
     * @param second 秒数
     * @return 处理后的时间
     */
    public static String getTimeBySecond(String time,int second){
        DateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        DateFormat oldDf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        Date olddate=null;
        try {
            olddate= oldDf.parse(time);
        } catch (ParseException e) {
            e.printStackTrace();
        }
        long currentTime = olddate.getTime() + second * 1000;
        Date date = new Date(currentTime);
        String nowTime="";
        nowTime= df.format(date);
        System.out.println(nowTime);
        return nowTime;
    }

}
