package cn.sntumc.utils;

import java.security.NoSuchAlgorithmException;
import java.util.Map;

public class PayUtil {

    /**
     * 获取公钥和私钥
     * @return
     */
    public static Map<String,String> getKey(){
        try {
            return RSAEncrypt.genKeyPair();
        } catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
            return null;
        }
    }
    /**
     * 加密
     * @param data
     * @param publicKey
     * @return
     */
    public static String encrypt(String data,String publicKey){

        String messageEn = null;
        try {
            messageEn = RSAEncrypt.encrypt(data,publicKey);
        } catch (Exception e) {
            e.printStackTrace();
        }
        return messageEn;
    }
    public static String decrypt(String data,String privateKey){
        String dataDec = null;
        try {
            dataDec = RSAEncrypt.decrypt(data,privateKey);
        } catch (Exception e) {
            e.printStackTrace();
        }
        return dataDec;
    }

//    public static void main(String[] args) {
//        Map<String,String> keys=getKey();
//        System.out.println("公钥:"+keys.get("publicKey"));
//        System.out.println("私钥:"+keys.get("privateKey"));
//       String rsaData= encrypt("{'abc':'as'}",keys.get("publicKey"));
//       System.out.println("加密后:"+rsaData);
//        String data= decrypt(rsaData,keys.get("privateKey"));
//        System.out.println("解密后:"+data);
//    }
}
