package cn.sntumc.utils;

import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;

/**
 * String操作类
 * @author Huiyuzhe
 */
public class StringUtil {

    /**
     * 判断是否为空
     * @param value 需要检查的字段
     * @return 是否为空
     */
    public static boolean isEmpty(String value) {
        if(null==value||"".equals(value)){
            return true;
        }
        return false;
    }

    /**
     * 转成String 类型
     * @param str 需要转的类型
     * @return 转成后的String类型
     */
    public static String getString(Object str){
        return str != null ? str.toString() : "";
    }

    /**
     *  脱敏 统一规则
     * @param value 脱敏字段
     * @param concealSize 隐藏 最大数量
     * @param concealStr 隐藏时显示的字符 如 *
     * @return 脱敏后的字段
     */
    public static String toConceal(String value,Integer concealSize,String concealStr) {
        if (null == value || "".equals(value)) {
            return value;
        }
        int len = value.length();
        int pamaone = len / 2;
        int pamatwo = pamaone - 1;
        int pamathree = len % 2;
        StringBuilder stringBuilder = new StringBuilder();
        if (len <= 2) {
            if (pamathree == 1) {
                return concealStr;
            }
            stringBuilder.append(concealStr);
            stringBuilder.append(value.charAt(len - 1));
        } else {
            if (pamatwo <= 0) {
                stringBuilder.append(value.substring(0, 1));
                stringBuilder.append(concealStr);
                stringBuilder.append(value.substring(len - 1, len));

            } else if (pamatwo >= concealSize / 2 && concealSize + 1 != len) {
                int pamafive = (len - concealSize) / 2;
                stringBuilder.append(value.substring(0, pamafive));
                for (int i = 0; i < concealSize; i++) {
                    stringBuilder.append(concealStr);
                }
                if ((pamathree == 0 && concealSize / 2 == 0) || (pamathree != 0 && concealSize % 2 != 0)) {
                    stringBuilder.append(value.substring(len - pamafive, len));
                } else {
                    stringBuilder.append(value.substring(len - (pamafive + 1), len));
                }
            } else {
                int pamafour = len - 2;
                stringBuilder.append(value.substring(0, 1));
                for (int i = 0; i < pamafour; i++) {
                    stringBuilder.append(concealStr);
                }
                stringBuilder.append(value.substring(len - 1, len));
            }
        }
        return stringBuilder.toString();
    }

    /**
     * 脱敏 6 统一规则  重载+1
     * @param value 脱敏字段
     * @return 脱敏后的字段
     */
    public static String toConceal(String value) {
        return toConceal(value,6,"*");
    }

    /**
     *  脱敏 统一规则  重载+2
     * @param value 脱敏字段
     * @param concealSize 需要脱敏的长度
     * @return 脱敏后的字段
     */
    public static String toConceal(String value,Integer concealSize) {
        return toConceal(value,concealSize,"*");
    }

    /**
     * 是否是数字
     * @param s 字符串
     * @return 是否
     */
    public static boolean isNumeric(String s) {
        try {
            Integer.parseInt(s);
            return true;
        } catch (Exception e) {
            return false;
        }
    }

}
