package cn.sntumc.utils;

import lombok.extern.slf4j.Slf4j;

import java.io.File;
import java.io.IOException;

/**
 * 文件操作类
 * @author Huiyuzhe
 */
public class FileUtil {

    /**
     * 异步删除文件
     * @param file 需要删除的文件
     */
    public static void deleteSyncFile(File file){
        if(file.exists()){
            new Thread(()->{
                while (file.exists()){
                    file.delete();
                    try {
                        Thread.sleep(1000);
                    } catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                }
            }).start();
        }
    }

    /**
     *删除文件夹
     * @param folderPath 文件夹路径
     */
    public static void delFolder(String folderPath) {
        do{
            try {
                delAllFile(folderPath); //删除完里面所有内容
                String filePath = folderPath;
                filePath = filePath.toString();
                java.io.File myFilePath = new java.io.File(filePath);
                myFilePath.delete(); //删除空文件夹
            } catch (Exception e) {
                e.printStackTrace();
            }
            try {
                Thread.sleep(1000);
            } catch (InterruptedException e) {
                e.printStackTrace();
            }
        }while (new File(folderPath).exists());

    }

    /**
     * 删除所有的文件
     * @param path 文件夹路径
     * @return 是否成功
     */
    public static boolean delAllFile(String path) {
        boolean flag = false;
        File file = new File(path);
        if (!file.exists()) {
            return flag;
        }
        if (!file.isDirectory()) {
            return flag;
        }
        String[] tempList = file.list();
        File temp = null;
        for (int i = 0; i < tempList.length; i++) {
            if (path.endsWith(File.separator)) {
                temp = new File(path + tempList[i]);
            } else {
                temp = new File(path + File.separator + tempList[i]);
            }
            if (temp.isFile()) {
                temp.delete();
            }
            if (temp.isDirectory()) {
                delAllFile(path + "/" + tempList[i]);//先删除文件夹里面的文件
                delFolder(path + "/" + tempList[i]);//再删除空文件夹
                flag = true;
            }
        }
        return flag;
    }

    /**
     * 创建文件
     * @param destFileName 创建的文件路径和名称
     * @return 当前创建的文件
     */

    public static File createFile(String destFileName) {
        File file = new File(destFileName);
        if (file.exists()) {
            System.out.println("创建单个文件" + destFileName + "失败，目标文件已存在！");
            return null;
        }
        if (destFileName.endsWith(File.separator)) {
            System.out.println("创建单个文件" + destFileName + "失败，目标文件不能为目录！");
            return null;
        }
        if (!file.getParentFile().exists()) {
            if (!file.getParentFile().mkdirs()) {
                System.out.println("创建目标文件所在目录失败！");
                return null;
            }
        }
        try {
            if (file.createNewFile()) {
                System.out.println("创建单个文件" + destFileName + "成功！");
                return file;
            } else {
                System.out.println("创建单个文件" + destFileName + "失败！");
                return null;
            }
        } catch (IOException e) {
            System.out.println("创建单个文件" + destFileName + "失败！" + e.getMessage());
            e.printStackTrace();
            return null;
        }
    }
}
