package cn.sntumc.model;

import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;
import java.util.List;

@Data
@NoArgsConstructor
public class PageModel<T> implements Serializable {
    private static final long serialVersionUID = 1L;
    //当前页
    private int currentPage;
    //每页的数量
    private int pageSize;
    //总记录数
    private long total;
    //总页数
    private int pages;
    //结果集
    private List<T> list;
    public PageModel(List<T> list){
        this.currentPage = 1;
        this.pageSize = list.size();
        this.pages = 1;
        this.list = list;
        this.total = list.size();
    }
}
