package cn.sntumc.encode;

import javax.crypto.Cipher;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.DESedeKeySpec;
import javax.crypto.spec.IvParameterSpec;
import java.security.Key;
/**
 * Created by sing on 2018/9/14.
 * 本Des加密 java 可与 ios（oc） 同步解密
 * <p>
 * Author: Huiyuzhe
 */

public class Des3Encode {
    private Des3Encode(){}

    private static Des3Encode des3Encode=new Des3Encode();

    /**
     * 创建实例
     * @param secretKey 秘钥
     * @param iv  加密的iv
     * @return 当前Des3Encode
     */
    public  Des3Encode instance(String secretKey, String iv){
        des3Encode.secretKey=secretKey;
        des3Encode.iv=iv;
        return des3Encode;
    }

    /**
     * 创建实例
     * @return 当前Des3Encode
     */
    public static Des3Encode instance(){
        return des3Encode;
    }

    // 密钥
    private   String secretKey = "uniteAppStaryea@12345678";
    // 向量
    private   String iv = "01234567";
    // 加解密统一使用的编码方式
    private final static String encoding = "utf-8";

    /**
     * 3DES加密
     * @param plainText 普通文本
     * @return 加密后的字段
     * @throws Exception 加密失败
     */
    public  String encode(String plainText) throws Exception {
        Key deskey = null;
        DESedeKeySpec spec = new DESedeKeySpec(secretKey.getBytes());
        SecretKeyFactory keyfactory = SecretKeyFactory.getInstance("desede");
        deskey = keyfactory.generateSecret(spec);

        Cipher cipher = Cipher.getInstance("desede/CBC/PKCS5Padding");
        IvParameterSpec ips = new IvParameterSpec(iv.getBytes());
        cipher.init(Cipher.ENCRYPT_MODE, deskey, ips);
        byte[] encryptData = cipher.doFinal(plainText.getBytes(encoding));
        return Base64Encode.encode(encryptData);
    }

    /**
     * 3DES解密
     * @param encryptText 加密文本
     * @return 解密后的字段
     * @throws Exception 解密失败
     */
    public  String decode(String encryptText) throws Exception {
        Key deskey = null;
        DESedeKeySpec spec = new DESedeKeySpec(secretKey.getBytes());
        SecretKeyFactory keyfactory = SecretKeyFactory.getInstance("desede");
        deskey = keyfactory.generateSecret(spec);
        Cipher cipher = Cipher.getInstance("desede/CBC/PKCS5Padding");
        IvParameterSpec ips = new IvParameterSpec(iv.getBytes());
        cipher.init(Cipher.DECRYPT_MODE, deskey, ips);

        byte[] decryptData = cipher.doFinal(Base64Encode.decode(encryptText));

        return new String(decryptData, encoding);
    }
}
