/*
 * Decompiled with CFR 0.152.
 */
package cn.sntumc.utils;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;

public class TimeUtil {
    public static String DATE_YYYY_MM_SS = "yyyy-MM-dd HH:mm:ss";

    public static String getNowDate() {
        SimpleDateFormat formatter = new SimpleDateFormat(DATE_YYYY_MM_SS);
        return formatter.format(new Date());
    }

    public static boolean belongCalendar(Date time, Date from, Date to) {
        Calendar date = Calendar.getInstance();
        date.setTime(time);
        Calendar after = Calendar.getInstance();
        after.setTime(from);
        Calendar before = Calendar.getInstance();
        before.setTime(to);
        return date.after(after) && date.before(before);
    }

    public static boolean belongCalendar(String time, String from, String to) throws ParseException {
        Calendar date = Calendar.getInstance();
        date.setTime(TimeUtil.stringToDate(time, DATE_YYYY_MM_SS));
        Calendar after = Calendar.getInstance();
        after.setTime(TimeUtil.stringToDate(from, DATE_YYYY_MM_SS));
        Calendar before = Calendar.getInstance();
        before.setTime(TimeUtil.stringToDate(to, DATE_YYYY_MM_SS));
        return date.after(after) && date.before(before);
    }

    public static String getPreMonth(Integer count) {
        Calendar cal = Calendar.getInstance();
        cal.add(2, count);
        SimpleDateFormat dft = new SimpleDateFormat(DATE_YYYY_MM_SS);
        String preMonth = dft.format(cal.getTime());
        return preMonth;
    }

    public static String getPreMonthByDate(String time, Integer count) throws ParseException {
        Calendar cal = Calendar.getInstance();
        cal.setTime(TimeUtil.stringToDate(time, DATE_YYYY_MM_SS));
        cal.add(2, count);
        SimpleDateFormat dft = new SimpleDateFormat(DATE_YYYY_MM_SS);
        String preMonth = dft.format(cal.getTime());
        return preMonth;
    }

    public static String getPreDays(Integer days) {
        Calendar cal = Calendar.getInstance();
        cal.add(5, days);
        Date date = cal.getTime();
        SimpleDateFormat format = new SimpleDateFormat(DATE_YYYY_MM_SS);
        return format.format(date);
    }

    public static String getPreDaysByDay(String timeStr, Integer days) throws ParseException {
        Calendar cal = Calendar.getInstance();
        SimpleDateFormat format = new SimpleDateFormat(DATE_YYYY_MM_SS);
        cal.setTime(format.parse(timeStr));
        cal.add(5, days);
        Date date = cal.getTime();
        return format.format(date);
    }

    public static boolean afterDays(String time) throws ParseException {
        SimpleDateFormat format = new SimpleDateFormat(DATE_YYYY_MM_SS);
        Date date1 = format.parse(time);
        return date1.after(new Date());
    }

    public static Integer getTwoTimeDays(String startTime, String endTime) throws ParseException {
        SimpleDateFormat format = new SimpleDateFormat(DATE_YYYY_MM_SS);
        Date date1 = format.parse(endTime);
        Date date2 = format.parse(startTime);
        return (int)((date1.getTime() - date2.getTime()) / 86400000L);
    }

    public static String transForDate(Long ms) {
        if (ms == null) {
            ms = 0L;
        }
        long msl = ms * 1000L;
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        String str = null;
        if (ms != null) {
            str = sdf.format(msl);
        }
        return str;
    }

    public static String transForDate(Long ms, String format) {
        if (ms == null) {
            ms = 0L;
        }
        long msl = ms * 1000L;
        SimpleDateFormat sdf = new SimpleDateFormat(format);
        String str = null;
        if (ms != null) {
            str = sdf.format(msl);
        }
        return str;
    }

    public static Long daysBetweenDay(Date first, Date second) throws ParseException {
        SimpleDateFormat sformat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        if (null == first) {
            first = new Date();
        }
        if (null == second) {
            second = new Date();
        }
        first = sformat.parse(sformat.format(first));
        second = sformat.parse(sformat.format(second));
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(first);
        long firstMills = calendar.getTimeInMillis();
        calendar.setTime(second);
        long secondMills = calendar.getTimeInMillis();
        long rateD = 86400000L;
        long rateH = 3600000L;
        long rateM = 60000L;
        long rateS = 1000L;
        long mills = secondMills - firstMills;
        long days = mills / rateD;
        long hours = mills % rateD / rateH;
        long minutes = mills % rateD % rateH / rateM;
        long seconds = mills % rateD % rateH % rateM / rateS;
        return minutes;
    }

    public static String formatThisTimeByMatch(String match) {
        SimpleDateFormat formatter = new SimpleDateFormat(match);
        return formatter.format(new Date());
    }

    public static String dateToString(Date data, String formatType) {
        return new SimpleDateFormat(formatType).format(data);
    }

    public static String longToString(long currentTime, String formatType) throws ParseException {
        Date date = TimeUtil.longToDate(currentTime, formatType);
        String strTime = TimeUtil.dateToString(date, formatType);
        return strTime;
    }

    public static Date stringToDate(String strTime, String formatType) throws ParseException {
        SimpleDateFormat formatter = new SimpleDateFormat(formatType);
        Date date = null;
        date = formatter.parse(strTime);
        return date;
    }

    public static Date longToDate(long currentTime, String formatType) throws ParseException {
        Date dateOld = new Date(currentTime);
        String sDateTime = TimeUtil.dateToString(dateOld, formatType);
        Date date = TimeUtil.stringToDate(sDateTime, formatType);
        return date;
    }

    public static long stringToLong(String strTime, String formatType) throws ParseException {
        Date date = TimeUtil.stringToDate(strTime, formatType);
        if (date == null) {
            return 0L;
        }
        long currentTime = TimeUtil.dateToLong(date);
        return currentTime;
    }

    public static long dateToLong(Date date) {
        return date.getTime();
    }
}

