/*
 * Decompiled with CFR 0.152.
 */
package cn.snowheart.dingtalk.robot.starter.client;

import cn.snowheart.dingtalk.robot.starter.entity.ActionCardButton;
import cn.snowheart.dingtalk.robot.starter.entity.ActionCardMessage;
import cn.snowheart.dingtalk.robot.starter.entity.BaseMessage;
import cn.snowheart.dingtalk.robot.starter.entity.DingTalkResponse;
import cn.snowheart.dingtalk.robot.starter.entity.FeedCardMessage;
import cn.snowheart.dingtalk.robot.starter.entity.FeedCardMessageItem;
import cn.snowheart.dingtalk.robot.starter.entity.LinkMessage;
import cn.snowheart.dingtalk.robot.starter.entity.MarkdownMessage;
import cn.snowheart.dingtalk.robot.starter.entity.TextMessage;
import cn.snowheart.dingtalk.robot.starter.exception.DingTalkException;
import cn.snowheart.dingtalk.robot.starter.type.HideAvatarType;
import cn.snowheart.dingtalk.robot.starter.type.ResponseCodeType;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLEncoder;
import java.util.List;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import org.apache.tomcat.util.codec.binary.Base64;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.MediaType;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

public class DingTalkRobotClient {
    private static final Logger log = LoggerFactory.getLogger(DingTalkRobotClient.class);
    @Autowired
    @Qualifier(value="dingTalkRobotRestTemplate")
    private RestTemplate restTemplate;
    @Value(value="${dingtalk.robot.prefix:https://oapi.dingtalk.com/robot/send}")
    private String urlPrefix;
    @Value(value="${dingtalk.robot.access-token}")
    private String accessToken;
    @Value(value="${dingtalk.robot.secret.secret-enabled:false}")
    private boolean secretEnable;
    @Value(value="${dingtalk.robot.secret.secret-token:null}")
    private String secretToken;

    public String getDefaultWebhook() {
        return this.getWebhook(this.accessToken, this.secretToken, this.secretEnable);
    }

    public String getWebhook(String accessToken) {
        return this.getWebhook(accessToken, null, false);
    }

    private static String getSign(String secret, Long timestamp) {
        try {
            String stringToSign = timestamp + "\n" + secret;
            Mac mac = Mac.getInstance("HmacSHA256");
            mac.init(new SecretKeySpec(secret.getBytes("UTF-8"), "HmacSHA256"));
            byte[] signData = mac.doFinal(stringToSign.getBytes("UTF-8"));
            String sign = URLEncoder.encode(new String(Base64.encodeBase64((byte[])signData)), "UTF-8");
            log.debug("\u3010\u53d1\u9001\u9489\u9489\u7fa4\u6d88\u606f\u3011\u83b7\u53d6\u5230\u7b7e\u540dsign = {}", (Object)sign);
            return sign;
        }
        catch (Exception e) {
            log.error("\u3010\u53d1\u9001\u9489\u9489\u7fa4\u6d88\u606f\u3011\u8ba1\u7b97\u7b7e\u540d\u5f02\u5e38\uff0cerrMsg = {}", (Throwable)e);
            return null;
        }
    }

    public DingTalkResponse sendMessageByURL(String url, BaseMessage message) {
        URI actualUrl;
        try {
            actualUrl = new URI(url);
        }
        catch (URISyntaxException e) {
            throw new RuntimeException("URL\u521b\u5efa\u62a5\u9519\uff01");
        }
        return this.sendMessageByURL(actualUrl, message);
    }

    public DingTalkResponse sendMessageByURL(URI url, BaseMessage message) {
        DingTalkResponse dingTalkResponse;
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        HttpEntity entity = new HttpEntity((Object)message.toMessageMap(), (MultiValueMap)headers);
        try {
            dingTalkResponse = (DingTalkResponse)this.restTemplate.postForObject(url, (Object)entity, DingTalkResponse.class);
        }
        catch (Exception e) {
            log.error(e.fillInStackTrace().toString());
            throw new DingTalkException(ResponseCodeType.UNKNOWN.getValue(), e.fillInStackTrace().toString());
        }
        if (dingTalkResponse == null) {
            throw new DingTalkException(ResponseCodeType.UNKNOWN.getValue(), "\u8bf7\u6c42\u9489\u9489\u62a5\u9519\uff01");
        }
        if (!ResponseCodeType.OK.getValue().equals(dingTalkResponse.getErrcode())) {
            throw new DingTalkException(dingTalkResponse.getErrcode(), dingTalkResponse.getErrmsg());
        }
        return dingTalkResponse;
    }

    public DingTalkResponse sendMessageByAccessToken(String accessToken, BaseMessage message) {
        return this.sendMessageByURL(this.getWebhook(accessToken), message);
    }

    public DingTalkResponse sendMessage(BaseMessage message) {
        return this.sendMessageByURL(this.getDefaultWebhook(), message);
    }

    public DingTalkResponse sendTextMessage(TextMessage message) {
        return this.sendMessage(message);
    }

    public DingTalkResponse sendTextMessage(String content) {
        return this.sendMessage(new TextMessage(content));
    }

    public DingTalkResponse sendTextMessage(String content, String[] atMobiles) {
        return this.sendMessage(new TextMessage(content, atMobiles));
    }

    public DingTalkResponse sendTextMessage(String content, boolean isAtAll) {
        return this.sendMessage(new TextMessage(content, isAtAll));
    }

    public DingTalkResponse sendLinkMessage(LinkMessage message) {
        return this.sendMessage(message);
    }

    public DingTalkResponse sendLinkMessage(String title, String text, String messageUrl) {
        return this.sendMessage(new LinkMessage(title, text, messageUrl));
    }

    public DingTalkResponse sendLinkMessage(String title, String text, String messageUrl, String picUrl) {
        return this.sendMessage(new LinkMessage(title, text, messageUrl, picUrl));
    }

    public DingTalkResponse sendMarkdownMessage(MarkdownMessage message) {
        return this.sendMessage(message);
    }

    public DingTalkResponse sendMarkdownMessage(String title, String text) {
        return this.sendMessage(new MarkdownMessage(title, text));
    }

    public DingTalkResponse sendMarkdownMessage(String title, String text, String[] atMobiles) {
        return this.sendMessage(new MarkdownMessage(title, text, atMobiles));
    }

    public DingTalkResponse sendMarkdownMessage(String title, String text, boolean isAtAll) {
        return this.sendMessage(new MarkdownMessage(title, text, isAtAll));
    }

    public DingTalkResponse sendActionCardMessage(ActionCardMessage message) {
        return this.sendMessage(message);
    }

    public DingTalkResponse sendActionCardMessage(String title, String text) {
        return this.sendMessage(new ActionCardMessage(title, text));
    }

    public DingTalkResponse sendActionCardMessage(String title, String text, HideAvatarType hideAvatar) {
        return this.sendMessage(new ActionCardMessage(title, text, hideAvatar));
    }

    public DingTalkResponse sendActionCardMessage(String title, String text, ActionCardButton button) {
        return this.sendMessage(new ActionCardMessage(title, text, button));
    }

    public DingTalkResponse sendActionCardMessage(String title, String text, HideAvatarType hideAvatar, ActionCardButton button) {
        return this.sendMessage(new ActionCardMessage(title, text, hideAvatar, button));
    }

    public DingTalkResponse sendFeedCardMessage(FeedCardMessage feedCardMessage) {
        return this.sendMessage(feedCardMessage);
    }

    public DingTalkResponse sendFeedCardMessage(List<FeedCardMessageItem> feedCardItems) {
        return this.sendMessage(new FeedCardMessage(feedCardItems));
    }

    public String getWebhook(String accessToken, String secretToken, boolean secretEnable) {
        String url = this.urlPrefix + "?access_token=" + accessToken;
        if (secretEnable) {
            Long timestamp = System.currentTimeMillis();
            url = url + "&timestamp=" + timestamp + "&sign=" + DingTalkRobotClient.getSign(secretToken, timestamp);
        }
        log.debug("The url contains sign is {}", (Object)url);
        return url;
    }

    public String getWebhook(String accessToken, String secretToken) {
        return this.getWebhook(accessToken, secretToken, true);
    }
}

