/*
 * Decompiled with CFR 0.152.
 */
package cn.snowheart.dingtalk.robot.starter.entity;

import cn.snowheart.dingtalk.robot.starter.entity.BaseMessage;
import cn.snowheart.dingtalk.robot.starter.type.MessageType;
import java.util.HashMap;
import java.util.Map;
import org.springframework.util.StringUtils;

public class TextMessage
extends BaseMessage {
    private String content;
    private String[] atMobiles;
    private boolean isAtAll;

    public TextMessage() {
    }

    public TextMessage(String content) {
        this.content = content;
    }

    public TextMessage(String content, String[] atMobiles) {
        this.content = content;
        this.atMobiles = atMobiles;
    }

    public TextMessage(String content, boolean isAtAll) {
        this.content = content;
        this.isAtAll = isAtAll;
    }

    @Override
    public Map toMessageMap() {
        if (StringUtils.isEmpty((Object)this.content) || !MessageType.text.equals((Object)this.msgtype)) {
            throw new IllegalArgumentException("please check the necessary parameters!");
        }
        HashMap<String, Object> resultMap = new HashMap<String, Object>(8);
        resultMap.put("msgtype", (Object)this.msgtype);
        HashMap<String, String> textItems = new HashMap<String, String>(8);
        textItems.put("content", this.content);
        resultMap.put("text", textItems);
        HashMap<String, Object> atItems = new HashMap<String, Object>(8);
        atItems.put("atMobiles", this.atMobiles);
        atItems.put("isAtAll", this.isAtAll);
        resultMap.put("at", atItems);
        return resultMap;
    }

    @Override
    protected void init() {
        this.msgtype = MessageType.text;
    }

    public String getContent() {
        return this.content;
    }

    public void setContent(String content) {
        this.content = content;
    }

    public String[] getAtMobiles() {
        return this.atMobiles;
    }

    public void setAtMobiles(String[] atMobiles) {
        this.atMobiles = atMobiles;
    }

    public boolean getIsAtAll() {
        return this.isAtAll;
    }

    public void setIsAtAll(boolean isAtAll) {
    }
}

